/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.jdbc;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import org.zalando.opentracing.jdbc.Activation;
import org.zalando.opentracing.jdbc.Lifecycle;
import org.zalando.opentracing.jdbc.operation.OperationName;
import org.zalando.opentracing.jdbc.span.SpanDecorator;

final class TracingQueryExecutionListener
implements QueryExecutionListener {
    private final Tracer tracer;
    private final OperationName operationName;
    private final Lifecycle lifecycle;
    private final Activation activation;
    private final SpanDecorator decorator;

    public void beforeQuery(ExecutionInfo info, List<QueryInfo> infos) {
        Method method = info.getMethod();
        List<String> queries = infos.stream().map(QueryInfo::getQuery).collect(Collectors.toList());
        String name = this.operationName.generate(method, queries);
        this.lifecycle.start(this.tracer, name).ifPresent(span -> this.beforeQuery(info, queries, (Span)span));
    }

    private void beforeQuery(ExecutionInfo info, List<String> queries, Span span) {
        Scope scope = this.activation.activate(this.tracer, span);
        Statement statement = info.getStatement();
        this.decorator.onQuery(span, statement, queries);
        this.save(info, Span.class, span);
        this.save(info, Scope.class, scope);
    }

    public void afterQuery(ExecutionInfo info, List<QueryInfo> queries) {
        this.restore(info, Span.class).ifPresent(span -> this.afterQuery(info, (Span)span));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterQuery(ExecutionInfo info, Span span) {
        try {
            if (!info.isSuccess()) {
                Statement statement = info.getStatement();
                Throwable error = info.getThrowable();
                this.decorator.onError(span, statement, error);
            }
        }
        finally {
            try {
                this.restore(info, Scope.class).ifPresent(Scope::close);
            }
            finally {
                span.finish();
            }
        }
    }

    private <T> void save(ExecutionInfo info, Class<T> type, T value) {
        info.addCustomValue(type.getName(), value);
    }

    private <T> Optional<T> restore(ExecutionInfo info, Class<T> type) {
        return Optional.ofNullable(info.getCustomValue(type.getName(), type));
    }

    @Generated
    public TracingQueryExecutionListener(Tracer tracer, OperationName operationName, Lifecycle lifecycle, Activation activation, SpanDecorator decorator) {
        this.tracer = tracer;
        this.operationName = operationName;
        this.lifecycle = lifecycle;
        this.activation = activation;
        this.decorator = decorator;
    }
}

