/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.jdbc.span;

import io.opentracing.Span;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Statement;
import java.util.Collections;
import org.apiguardian.api.API;
import org.zalando.opentracing.jdbc.span.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class ErrorStackSpanDecorator
implements SpanDecorator {
    @Override
    public void onError(Span span, Statement statement, Throwable error) {
        span.log(Collections.singletonMap("stack", this.stackTraceAsString(error)));
    }

    private String stackTraceAsString(Throwable throwable) {
        StringWriter output = new StringWriter();
        throwable.printStackTrace(new PrintWriter(output));
        return output.toString();
    }
}

