/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.jdbc.span;

import io.opentracing.Span;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.zalando.opentracing.jdbc.span.CompositeSpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public interface SpanDecorator {
    default public void onQuery(Span span, Statement statement, List<String> queries) throws SQLException {
    }

    default public void onError(Span span, Statement statement, Throwable error) throws SQLException {
    }

    public static SpanDecorator composite(SpanDecorator decorator, SpanDecorator ... decorators) {
        ArrayList<SpanDecorator> list = new ArrayList<SpanDecorator>(decorators.length + 1);
        list.add(decorator);
        Collections.addAll(list, decorators);
        return SpanDecorator.composite(Collections.unmodifiableList(list));
    }

    public static SpanDecorator composite(Iterable<SpanDecorator> decorators) {
        return new CompositeSpanDecorator(decorators);
    }
}

