/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.jdbc.span;

import io.opentracing.Span;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tag;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import org.apiguardian.api.API;
import org.zalando.opentracing.jdbc.span.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class PeerAddressSpanDecorator
implements SpanDecorator {
    @API(status=API.Status.EXPERIMENTAL)
    public static final Tag<String> PEER_ADDRESS = new StringTag("peer.address");

    @Override
    public void onQuery(Span span, Statement statement, List<String> queries) throws SQLException {
        Optional.ofNullable(statement.getConnection().getMetaData().getURL()).map(this::trimPrefix).ifPresent(url -> span.setTag(PEER_ADDRESS, url));
    }

    private String trimPrefix(String url) {
        return PeerAddressSpanDecorator.trimPrefix(url, "jdbc:");
    }

    static String trimPrefix(String s, String prefix) {
        return s.startsWith(prefix) ? s.substring(prefix.length()) : s;
    }
}

