/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.jdbc;

import io.opentracing.Tracer;
import javax.annotation.CheckReturnValue;
import javax.sql.DataSource;
import lombok.Generated;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import org.apiguardian.api.API;
import org.zalando.opentracing.jdbc.Activation;
import org.zalando.opentracing.jdbc.Lifecycle;
import org.zalando.opentracing.jdbc.NewSpanLifecycle;
import org.zalando.opentracing.jdbc.NoOpActivation;
import org.zalando.opentracing.jdbc.TracingQueryExecutionListener;
import org.zalando.opentracing.jdbc.operation.DefaultOperationName;
import org.zalando.opentracing.jdbc.operation.OperationName;
import org.zalando.opentracing.jdbc.span.SpanDecorator;
import org.zalando.opentracing.jdbc.span.StandardSpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class DataSourceTracer {
    private final Tracer tracer;
    private final OperationName operationName;
    private final Lifecycle lifecycle;
    private final Activation activation;
    private final SpanDecorator decorator;

    public DataSourceTracer(Tracer tracer) {
        this(tracer, new DefaultOperationName(), new NewSpanLifecycle(), new NoOpActivation(), new StandardSpanDecorator());
    }

    @CheckReturnValue
    public DataSourceTracer withOperationName(OperationName operationName) {
        return new DataSourceTracer(this.tracer, operationName, this.lifecycle, this.activation, this.decorator);
    }

    @CheckReturnValue
    public DataSourceTracer withLifecycle(Lifecycle lifecycle) {
        return new DataSourceTracer(this.tracer, this.operationName, lifecycle, this.activation, this.decorator);
    }

    @CheckReturnValue
    public DataSourceTracer withActivation(Activation activation) {
        return new DataSourceTracer(this.tracer, this.operationName, this.lifecycle, activation, this.decorator);
    }

    @CheckReturnValue
    public DataSourceTracer withAdditionalSpanDecorators(SpanDecorator first, SpanDecorator ... decorators) {
        return this.withSpanDecorators(this.decorator, SpanDecorator.composite(first, decorators));
    }

    @CheckReturnValue
    public DataSourceTracer withSpanDecorators(SpanDecorator decorator, SpanDecorator ... decorators) {
        return new DataSourceTracer(this.tracer, this.operationName, this.lifecycle, this.activation, SpanDecorator.composite(decorator, decorators));
    }

    @CheckReturnValue
    public DataSource trace(DataSource dataSource) {
        return ProxyDataSourceBuilder.create((DataSource)dataSource).listener((QueryExecutionListener)new TracingQueryExecutionListener(this.tracer, this.operationName, this.lifecycle, this.activation, this.decorator)).build();
    }

    @Generated
    private DataSourceTracer(Tracer tracer, OperationName operationName, Lifecycle lifecycle, Activation activation, SpanDecorator decorator) {
        this.tracer = tracer;
        this.operationName = operationName;
        this.lifecycle = lifecycle;
        this.activation = activation;
        this.decorator = decorator;
    }
}

