/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.jdbc.span;

import io.opentracing.Span;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.zalando.opentracing.jdbc.span.Peer;
import org.zalando.opentracing.jdbc.span.PeerParser;
import org.zalando.opentracing.jdbc.span.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class PeerSpanDecorator
implements SpanDecorator {
    private final PeerParser parser = PeerParser.create();
    @API(status=API.Status.INTERNAL)
    private static final Tag<String> PEER_HOST_IPV4 = new StringTag("peer.ipv4");

    @Override
    public void onQuery(Span span, Statement statement, List<String> queries) throws SQLException {
        Connection connection = statement.getConnection();
        Peer url = this.parser.parse(connection.getMetaData().getURL());
        this.tag(span, (Tag)Tags.PEER_HOSTNAME, (Object)url.getHostname());
        this.tag(span, (Tag)Tags.PEER_PORT, (Object)url.getPort());
        this.tag(span, PEER_HOST_IPV4, url.getIpv4());
        this.tag(span, (Tag)Tags.PEER_HOST_IPV6, (Object)url.getIpv6());
    }

    private <T> void tag(Span span, Tag<T> tag, @Nullable T value) {
        if (value != null) {
            span.setTag(tag, value);
        }
    }
}

