/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy;

import io.opentracing.Span;
import io.opentracing.tag.Tag;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.TagListener;

@API(status=API.Status.EXPERIMENTAL)
public final class AutoBaggage
implements TagListener {
    private final String tagKey;
    private final String baggageKey;

    public AutoBaggage(String key) {
        this(key, key);
    }

    @Override
    public <T> void onTag(Span span, Tag<T> tag, T value) {
        if (this.baggageExists(span)) {
            return;
        }
        if (this.tagKey.equals(tag.getKey())) {
            span.setBaggageItem(this.baggageKey, String.valueOf(value));
        }
    }

    private boolean baggageExists(Span span) {
        return span.getBaggageItem(this.baggageKey) != null;
    }

    public AutoBaggage(String tagKey, String baggageKey) {
        this.tagKey = tagKey;
        this.baggageKey = baggageKey;
    }
}

