/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy;

import io.opentracing.Span;
import java.util.Map;
import org.zalando.opentracing.proxy.LogListener;

final class CompositeLogListener
implements LogListener {
    private final Iterable<LogListener> listeners;

    @Override
    public void onLog(Span span, long timestamp, String event) {
        this.listeners.forEach(listener -> listener.onLog(span, timestamp, event));
    }

    @Override
    public void onLog(Span span, String event) {
        this.listeners.forEach(listener -> listener.onLog(span, event));
    }

    @Override
    public void onLog(Span span, long timestamp, Map<String, ?> fields) {
        this.listeners.forEach(listener -> listener.onLog(span, timestamp, fields));
    }

    @Override
    public void onLog(Span span, Map<String, ?> fields) {
        this.listeners.forEach(listener -> listener.onLog(span, fields));
    }

    public CompositeLogListener(Iterable<LogListener> listeners) {
        this.listeners = listeners;
    }
}

