/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy;

import com.google.common.base.CaseFormat;
import org.zalando.opentracing.proxy.CaseFormatDetector;

final class DefaultCaseFormatDetector
implements CaseFormatDetector {
    DefaultCaseFormatDetector() {
    }

    @Override
    public CaseFormat detect(String s) {
        if (this.isLowerCase(s)) {
            if (this.hasHyphen(s)) {
                return CaseFormat.LOWER_HYPHEN;
            }
            return CaseFormat.LOWER_UNDERSCORE;
        }
        if (this.isUpperCase(s)) {
            return CaseFormat.UPPER_UNDERSCORE;
        }
        if (this.startsLowerCase(s)) {
            return CaseFormat.LOWER_CAMEL;
        }
        return CaseFormat.UPPER_CAMEL;
    }

    private boolean isLowerCase(String s) {
        return s.equals(s.toLowerCase());
    }

    private boolean isUpperCase(String s) {
        return s.equals(s.toUpperCase());
    }

    private boolean hasHyphen(String s) {
        return s.contains("-");
    }

    private boolean startsLowerCase(String s) {
        return Character.isLowerCase(s.charAt(0));
    }
}

