/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy;

import io.opentracing.Scope;
import io.opentracing.Span;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.organicdesign.fp.collections.ImMap;
import org.organicdesign.fp.collections.PersistentHashMap;
import org.slf4j.MDC;
import org.zalando.opentracing.proxy.BaggageListener;
import org.zalando.opentracing.proxy.Registry;
import org.zalando.opentracing.proxy.ScopeListener;

@API(status=API.Status.EXPERIMENTAL)
public final class LogCorrelation
implements ScopeListener,
BaggageListener {
    private final ImMap<Seed, String> seeds;
    private final ImMap<String, String> baggage;

    public LogCorrelation() {
        this((ImMap<Seed, String>)PersistentHashMap.empty(), (ImMap<String, String>)PersistentHashMap.empty());
    }

    public LogCorrelation withTraceId(String contextKey) {
        Seed seed = span -> span.context().toTraceId();
        return new LogCorrelation((ImMap<Seed, String>)this.seeds.assoc((Object)seed, (Object)contextKey), this.baggage);
    }

    public LogCorrelation withSpanId(String contextKey) {
        Seed seed = span -> span.context().toSpanId();
        return new LogCorrelation((ImMap<Seed, String>)this.seeds.assoc((Object)seed, (Object)contextKey), this.baggage);
    }

    public LogCorrelation withBaggage(String key) {
        return this.withBaggage(key, key);
    }

    public LogCorrelation withBaggage(String baggageKey, String contextKey) {
        Seed seed = span -> span.getBaggageItem(baggageKey);
        return new LogCorrelation((ImMap<Seed, String>)this.seeds.assoc((Object)seed, (Object)contextKey), (ImMap<String, String>)this.baggage.assoc((Object)baggageKey, (Object)contextKey));
    }

    @Override
    public void onActivated(Scope scope, Span span) {
        this.seeds.forEach((seed, contextKey) -> Optional.ofNullable(seed.valueOf(span)).ifPresent(value -> MDC.put((String)contextKey, (String)value)));
    }

    @Override
    public void onBaggage(Span span, String baggageKey, String value) {
        Optional.ofNullable(this.baggage.get((Object)baggageKey)).ifPresent(contextKey -> MDC.put((String)contextKey, (String)value));
    }

    @Override
    public void onClosing(Scope scope, Span span) {
        this.seeds.forEach((ignored, key) -> MDC.remove((String)key));
        this.baggage.forEach((ignored, key) -> MDC.remove((String)key));
    }

    @Override
    public <R extends Registry<R>> R registerTo(R registry) {
        return registry.withScopeListener(this).withBaggageListener(this);
    }

    private LogCorrelation(ImMap<Seed, String> seeds, ImMap<String, String> baggage) {
        this.seeds = seeds;
        this.baggage = baggage;
    }

    @FunctionalInterface
    private static interface Seed {
        @Nullable
        public String valueOf(Span var1);
    }
}

