/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy;

import io.opentracing.Span;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.CompositeLogListener;
import org.zalando.opentracing.proxy.Plugin;
import org.zalando.opentracing.proxy.Registry;

@API(status=API.Status.MAINTAINED)
@FunctionalInterface
public interface LogListener
extends Plugin {
    default public void onLog(Span span, long timestamp, String event) {
        this.onLog(span, timestamp, Collections.singletonMap("event", event));
    }

    default public void onLog(Span span, String event) {
        this.onLog(span, Collections.singletonMap("event", event));
    }

    default public void onLog(Span span, long timestamp, Map<String, ?> fields) {
        this.onLog(span, fields);
    }

    public void onLog(Span var1, Map<String, ?> var2);

    @Override
    default public <R extends Registry<R>> R registerTo(R registry) {
        return registry.withLogListener(this);
    }

    public static LogListener composite(LogListener ... listeners) {
        return LogListener.composite(Arrays.asList(listeners));
    }

    public static LogListener composite(Iterable<LogListener> listeners) {
        return new CompositeLogListener(listeners);
    }
}

