/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy;

import io.opentracing.Span;
import java.util.Map;
import org.zalando.opentracing.proxy.BaggageListener;
import org.zalando.opentracing.proxy.LogListener;
import org.zalando.opentracing.proxy.Naming;
import org.zalando.opentracing.proxy.Registry;
import org.zalando.opentracing.proxy.ScopeListener;
import org.zalando.opentracing.proxy.SpanListener;
import org.zalando.opentracing.proxy.TagListener;

final class Options
implements Registry<Options> {
    private final Naming naming;
    private final TagListener tagListener;
    private final LogListener logListener;
    private final BaggageListener baggageListener;
    private final SpanListener spanListener;
    private final ScopeListener scopeListener;

    Options() {
        this(Defaults.ORIGINAL, Defaults.TagListeners.NONE, Defaults.LogListeners.NONE, Defaults.BaggageListeners.NONE, Defaults.SpanListeners.NONE, Defaults.ScopeListeners.NONE);
    }

    @Override
    public Options withNaming(Naming naming) {
        return new Options(naming, this.tagListener, this.logListener, this.baggageListener, this.spanListener, this.scopeListener);
    }

    @Override
    public Options withTagListener(TagListener additionalTagListener) {
        return new Options(this.naming, TagListener.composite(this.tagListener, additionalTagListener), this.logListener, this.baggageListener, this.spanListener, this.scopeListener);
    }

    @Override
    public Options withLogListener(LogListener additionalLogListener) {
        return new Options(this.naming, this.tagListener, LogListener.composite(this.logListener, additionalLogListener), this.baggageListener, this.spanListener, this.scopeListener);
    }

    @Override
    public Options withBaggageListener(BaggageListener additionalBaggageListener) {
        return new Options(this.naming, this.tagListener, this.logListener, BaggageListener.composite(this.baggageListener, additionalBaggageListener), this.spanListener, this.scopeListener);
    }

    @Override
    public Options withSpanListener(SpanListener additionalSpanListener) {
        return new Options(this.naming, this.tagListener, this.logListener, this.baggageListener, SpanListener.composite(this.spanListener, additionalSpanListener), this.scopeListener);
    }

    @Override
    public Options withScopeListener(ScopeListener additionalScopeListener) {
        return new Options(this.naming, this.tagListener, this.logListener, this.baggageListener, this.spanListener, ScopeListener.composite(this.scopeListener, additionalScopeListener));
    }

    Naming naming() {
        return this.naming;
    }

    TagListener tags() {
        return this.tagListener;
    }

    LogListener logs() {
        return this.logListener;
    }

    BaggageListener baggage() {
        return this.baggageListener;
    }

    SpanListener spans() {
        return this.spanListener;
    }

    ScopeListener scopes() {
        return this.scopeListener;
    }

    public Options(Naming naming, TagListener tagListener, LogListener logListener, BaggageListener baggageListener, SpanListener spanListener, ScopeListener scopeListener) {
        this.naming = naming;
        this.tagListener = tagListener;
        this.logListener = logListener;
        this.baggageListener = baggageListener;
        this.spanListener = spanListener;
        this.scopeListener = scopeListener;
    }

    private static final class Defaults {
        static final Naming ORIGINAL = name -> name;

        private Defaults() {
        }

        static enum ScopeListeners implements ScopeListener
        {
            NONE;

        }

        static enum SpanListeners implements SpanListener
        {
            NONE;

        }

        static enum BaggageListeners implements BaggageListener
        {
            NONE;


            @Override
            public void onBaggage(Span span, String key, String value) {
            }
        }

        static enum LogListeners implements LogListener
        {
            NONE;


            @Override
            public void onLog(Span span, Map<String, ?> fields) {
            }
        }

        static enum TagListeners implements TagListener
        {
            NONE;

        }
    }
}

