/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import java.util.Optional;
import javax.annotation.Nullable;
import org.zalando.opentracing.proxy.ForwardingScopeManager;
import org.zalando.opentracing.proxy.Options;
import org.zalando.opentracing.proxy.ProxyScope;
import org.zalando.opentracing.proxy.ProxySpan;

final class ProxyScopeManager
extends ForwardingScopeManager {
    private final ScopeManager delegate;
    private final Options options;

    @Override
    protected ScopeManager delegate() {
        return this.delegate;
    }

    @Override
    public Scope activate(Span span) {
        Scope original = super.activate(ProxySpan.unwrap(span));
        ProxyScope scope = new ProxyScope(original, span, this.options);
        this.options.scopes().onActivated(scope, span);
        return scope;
    }

    @Override
    @Nullable
    public Span activeSpan() {
        return Optional.ofNullable(super.activeSpan()).map(this::decorate).orElse(null);
    }

    private ProxySpan decorate(Span span) {
        return new ProxySpan(span, this.options);
    }

    public ProxyScopeManager(ScopeManager delegate, Options options) {
        this.delegate = delegate;
        this.options = options;
    }
}

