/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.ForwardingTracer;
import org.zalando.opentracing.proxy.Options;
import org.zalando.opentracing.proxy.Plugin;
import org.zalando.opentracing.proxy.ProxyScope;
import org.zalando.opentracing.proxy.ProxyScopeManager;
import org.zalando.opentracing.proxy.ProxySpan;
import org.zalando.opentracing.proxy.ProxySpanBuilder;

@API(status=API.Status.EXPERIMENTAL)
public final class ProxyTracer
extends ForwardingTracer {
    private final Tracer delegate;
    private final Options options;

    public ProxyTracer(Tracer tracer) {
        this(tracer, new Options());
    }

    @Override
    protected Tracer delegate() {
        return this.delegate;
    }

    public ProxyTracer with(Plugin plugin) {
        return new ProxyTracer(this.delegate, plugin.registerTo(this.options));
    }

    @Override
    public Tracer.SpanBuilder buildSpan(String operationName) {
        Tracer.SpanBuilder builder = super.buildSpan(this.options.naming().rename(operationName));
        return new ProxySpanBuilder(builder, this.options);
    }

    @Override
    public ScopeManager scopeManager() {
        return new ProxyScopeManager(super.scopeManager(), this.options);
    }

    @Override
    public Scope activateSpan(Span span) {
        Scope original = super.activateSpan(ProxySpan.unwrap(span));
        ProxyScope scope = new ProxyScope(original, span, this.options);
        this.options.scopes().onActivated(scope, span);
        return scope;
    }

    @Override
    @Nullable
    public Span activeSpan() {
        return Optional.ofNullable(super.activeSpan()).map(this::decorate).orElse(null);
    }

    private ProxySpan decorate(Span span) {
        return new ProxySpan(span, this.options);
    }

    private ProxyTracer(Tracer delegate, Options options) {
        this.delegate = delegate;
        this.options = options;
    }
}

