/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy;

import io.opentracing.Scope;
import io.opentracing.Span;
import java.util.Arrays;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.CompositeScopeListener;
import org.zalando.opentracing.proxy.Plugin;
import org.zalando.opentracing.proxy.Registry;

@API(status=API.Status.MAINTAINED)
public interface ScopeListener
extends Plugin {
    default public void onActivated(Scope scope, Span span) {
    }

    default public void onClosing(Scope scope, Span span) {
    }

    default public void onClosed(Scope scope, Span span) {
    }

    @Override
    default public <R extends Registry<R>> R registerTo(R registry) {
        return registry.withScopeListener(this);
    }

    public static ScopeListener composite(ScopeListener ... listeners) {
        return ScopeListener.composite(Arrays.asList(listeners));
    }

    public static ScopeListener composite(Iterable<ScopeListener> listeners) {
        return new CompositeScopeListener(listeners);
    }
}

