package org.zalando.opentracing.proxy;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tag;

import java.util.Map;

abstract class ForwardingSpan implements Span {

    protected abstract Span delegate();
    protected abstract Span create(final Span delegate);
    
    @Override
    public SpanContext context() {
        return delegate().context();
    }

    @Override
    public Span setTag(final String key, final String value) {
        return create(delegate().setTag(key, value));
    }

    @Override
    public Span setTag(final String key, final boolean value) {
        return create(delegate().setTag(key, value));
    }

    @Override
    public Span setTag(final String key, final Number value) {
        return create(delegate().setTag(key, value));
    }

    @Override
    public <T> Span setTag(final Tag<T> tag, final T value) {
        return create(delegate().setTag(tag, value));
    }

    @Override
    public Span log(final Map<String, ?> fields) {
        return create(delegate().log(fields));
    }

    @Override
    public Span log(final long timestampMicroseconds, final Map<String, ?> fields) {
        return create(delegate().log(timestampMicroseconds, fields));
    }

    @Override
    public Span log(final String event) {
        return create(delegate().log(event));
    }

    @Override
    public Span log(final long timestampMicroseconds, final String event) {
        return create(delegate().log(timestampMicroseconds, event));
    }

    @Override
    public Span setBaggageItem(final String key, final String value) {
        return create(delegate().setBaggageItem(key, value));
    }

    @Override
    public String getBaggageItem(final String key) {
        return delegate().getBaggageItem(key);
    }

    @Override
    public Span setOperationName(final String operationName) {
        return create(delegate().setOperationName(operationName));
    }

    @Override
    public void finish() {
        delegate().finish();
    }

    @Override
    public void finish(final long finishMicros) {
        delegate().finish(finishMicros);
    }

}
