package org.zalando.opentracing.proxy;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer.SpanBuilder;
import io.opentracing.tag.Tag;

import javax.annotation.Nullable;

abstract class ForwardingSpanBuilder implements SpanBuilder {

    protected abstract SpanBuilder delegate();
    protected abstract SpanBuilder create(final SpanBuilder delegate);

    @Override
    public SpanBuilder asChildOf(@Nullable final SpanContext parent) {
        return create(delegate().asChildOf(parent));
    }

    @Override
    public SpanBuilder asChildOf(@Nullable final Span parent) {
        return create(delegate().asChildOf(parent));
    }

    @Override
    public SpanBuilder addReference(final String referenceType, final SpanContext referencedContext) {
        return create(delegate().addReference(referenceType, referencedContext));
    }

    @Override
    public SpanBuilder ignoreActiveSpan() {
        return create(delegate().ignoreActiveSpan());
    }

    @Override
    public SpanBuilder withTag(final String key, final String value) {
        return create(delegate().withTag(key, value));
    }

    @Override
    public SpanBuilder withTag(final String key, final boolean value) {
        return create(delegate().withTag(key, value));
    }

    @Override
    public SpanBuilder withTag(final String key, final Number value) {
        return create(delegate().withTag(key, value));
    }

    @Override
    public <T> SpanBuilder withTag(final Tag<T> tag, final T value) {
        return create(delegate().withTag(tag, value));
    }

    @Override
    public SpanBuilder withStartTimestamp(final long microseconds) {
        return create(delegate().withStartTimestamp(microseconds));
    }

    @Override
    public Span start() {
        return delegate().start();
    }

}
