package org.zalando.opentracing.proxy;

import io.opentracing.Span;
import io.opentracing.Tracer.SpanBuilder;
import io.opentracing.tag.BooleanTag;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tag;
import lombok.AllArgsConstructor;

import javax.annotation.Nullable;

import static org.zalando.opentracing.proxy.ProxySpan.unwrap;

@AllArgsConstructor
final class ProxySpanBuilder extends ForwardingSpanBuilder {

    private final SpanBuilder delegate;
    private final Options options;

    @Override
    protected SpanBuilder delegate() {
        return delegate;
    }

    @Override
    public SpanBuilder asChildOf(@Nullable final Span parent) {
        return super.asChildOf(unwrap(parent));
    }

    @Override
    protected SpanBuilder create(final SpanBuilder delegate) {
        return new ProxySpanBuilder(delegate, options);
    }

    @Override
    public SpanBuilder withTag(final String key, final String value) {
        final SpanBuilder builder = super.withTag(key, value);
        options.tags().onTag(builder, new StringTag(key), value);
        return builder;
    }

    @Override
    public SpanBuilder withTag(final String key, final boolean value) {
        final SpanBuilder builder = super.withTag(key, value);
        options.tags().onTag(builder, new BooleanTag(key), value);
        return builder;
    }

    @Override
    public SpanBuilder withTag(final String key, final Number value) {
        final SpanBuilder builder = super.withTag(key, value);
        options.tags().onTag(builder, new NumberTag(key), value);
        return builder;
    }

    @Override
    public <T> SpanBuilder withTag(final Tag<T> tag, final T value) {
        final SpanBuilder builder = super.withTag(tag, value);
        options.tags().onTag(builder, tag, value);
        return builder;
    }

    @Override
    public Span start() {
        final ProxySpan span = new ProxySpan(super.start(), options);
        options.spans().onStarted(span);
        return span;
    }

}
