/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy;

import io.opentracing.Span;
import java.util.Optional;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.BaggageListener;
import org.zalando.opentracing.proxy.Registry;
import org.zalando.opentracing.proxy.SpanListener;

@API(status=API.Status.EXPERIMENTAL)
public final class AutoTagging
implements SpanListener,
BaggageListener {
    private final String baggageKey;
    private final String tagKey;

    public AutoTagging(String key) {
        this(key, key);
    }

    @Override
    public void onStarted(Span span) {
        Optional.ofNullable(span.getBaggageItem(this.baggageKey)).ifPresent(value -> this.tag(span, (String)value));
    }

    @Override
    public void onBaggage(Span span, String key, String value) {
        if (this.baggageKey.equals(key)) {
            this.tag(span, value);
        }
    }

    private void tag(Span span, String baggageItem) {
        span.setTag(this.tagKey, baggageItem);
    }

    @Override
    public <R extends Registry<R>> R registerTo(R registry) {
        return registry.withSpanListener(this).withBaggageListener(this);
    }

    public AutoTagging(String baggageKey, String tagKey) {
        this.baggageKey = baggageKey;
        this.tagKey = tagKey;
    }
}

