/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy;

import io.opentracing.Span;
import io.opentracing.tag.BooleanTag;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tag;
import java.util.Map;
import java.util.Optional;
import org.zalando.opentracing.proxy.ForwardingSpan;
import org.zalando.opentracing.proxy.NumberTag;
import org.zalando.opentracing.proxy.Options;

final class ProxySpan
extends ForwardingSpan {
    private final Span delegate;
    private final Options options;

    @Override
    protected Span delegate() {
        return this.delegate;
    }

    @Override
    protected Span create(Span delegate) {
        return new ProxySpan(delegate, this.options);
    }

    @Override
    public Span setTag(String key, String value) {
        Span span = super.setTag(key, value);
        this.options.tags().onTag(span, new StringTag(key), value);
        return span;
    }

    @Override
    public Span setTag(String key, boolean value) {
        Span span = super.setTag(key, value);
        this.options.tags().onTag(span, new BooleanTag(key), Boolean.valueOf(value));
        return span;
    }

    @Override
    public Span setTag(String key, Number value) {
        Span span = super.setTag(key, value);
        this.options.tags().onTag(span, new NumberTag(key), value);
        return span;
    }

    @Override
    public <T> Span setTag(Tag<T> tag, T value) {
        Span span = super.setTag(tag, value);
        this.options.tags().onTag(span, tag, value);
        return span;
    }

    @Override
    public Span log(Map<String, ?> fields) {
        Span span = super.log(fields);
        this.options.logs().onLog(span, fields);
        return span;
    }

    @Override
    public Span log(long timestamp, Map<String, ?> fields) {
        Span span = super.log(timestamp, fields);
        this.options.logs().onLog(span, timestamp, fields);
        return span;
    }

    @Override
    public Span log(String event) {
        Span span = super.log(event);
        this.options.logs().onLog(span, event);
        return span;
    }

    @Override
    public Span log(long timestamp, String event) {
        Span span = super.log(timestamp, event);
        this.options.logs().onLog(span, timestamp, event);
        return span;
    }

    @Override
    public Span setBaggageItem(String key, String value) {
        Span span = super.setBaggageItem(key, value);
        this.options.baggage().onBaggage(span, key, value);
        return span;
    }

    @Override
    public Span setOperationName(String operationName) {
        return super.setOperationName(this.options.naming().rename(operationName));
    }

    @Override
    public void finish() {
        this.options.spans().onFinishing(this);
        super.finish();
        this.options.spans().onFinished(this);
    }

    @Override
    public void finish(long finishMicros) {
        this.options.spans().onFinishing(this);
        super.finish(finishMicros);
        this.options.spans().onFinished(this);
    }

    static Span unwrap(Span span) {
        return Optional.of(span).filter(ProxySpan.class::isInstance).map(ProxySpan.class::cast).map(ProxySpan::delegate).map(ProxySpan::unwrap).orElse(span);
    }

    public ProxySpan(Span delegate, Options options) {
        this.delegate = delegate;
        this.options = options;
    }
}

