/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.BooleanTag;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tag;
import javax.annotation.Nullable;
import org.zalando.opentracing.proxy.ForwardingSpanBuilder;
import org.zalando.opentracing.proxy.NumberTag;
import org.zalando.opentracing.proxy.Options;
import org.zalando.opentracing.proxy.ProxySpan;

final class ProxySpanBuilder
extends ForwardingSpanBuilder {
    private final Tracer.SpanBuilder delegate;
    private final Options options;

    @Override
    protected Tracer.SpanBuilder delegate() {
        return this.delegate;
    }

    @Override
    public Tracer.SpanBuilder asChildOf(@Nullable Span parent) {
        return super.asChildOf(ProxySpan.unwrap(parent));
    }

    @Override
    protected Tracer.SpanBuilder create(Tracer.SpanBuilder delegate) {
        return new ProxySpanBuilder(delegate, this.options);
    }

    @Override
    public Tracer.SpanBuilder withTag(String key, String value) {
        Tracer.SpanBuilder builder = super.withTag(key, value);
        this.options.tags().onTag(builder, new StringTag(key), value);
        return builder;
    }

    @Override
    public Tracer.SpanBuilder withTag(String key, boolean value) {
        Tracer.SpanBuilder builder = super.withTag(key, value);
        this.options.tags().onTag(builder, new BooleanTag(key), Boolean.valueOf(value));
        return builder;
    }

    @Override
    public Tracer.SpanBuilder withTag(String key, Number value) {
        Tracer.SpanBuilder builder = super.withTag(key, value);
        this.options.tags().onTag(builder, new NumberTag(key), value);
        return builder;
    }

    @Override
    public <T> Tracer.SpanBuilder withTag(Tag<T> tag, T value) {
        Tracer.SpanBuilder builder = super.withTag(tag, value);
        this.options.tags().onTag(builder, tag, value);
        return builder;
    }

    @Override
    public Span start() {
        ProxySpan span = new ProxySpan(super.start(), this.options);
        this.options.spans().onStarted(span);
        return span;
    }

    public ProxySpanBuilder(Tracer.SpanBuilder delegate, Options options) {
        this.delegate = delegate;
        this.options = options;
    }
}

