/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy;

import io.opentracing.Span;
import java.util.Arrays;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.CompositeSpanListener;
import org.zalando.opentracing.proxy.Plugin;
import org.zalando.opentracing.proxy.Registry;

@API(status=API.Status.MAINTAINED)
public interface SpanListener
extends Plugin {
    default public void onStarted(Span span) {
    }

    default public void onFinishing(Span span) {
    }

    default public void onFinished(Span span) {
    }

    @Override
    default public <R extends Registry<R>> R registerTo(R registry) {
        return registry.withSpanListener(this);
    }

    public static SpanListener composite(SpanListener ... listeners) {
        return SpanListener.composite(Arrays.asList(listeners));
    }

    public static SpanListener composite(Iterable<SpanListener> listeners) {
        return new CompositeSpanListener(listeners);
    }
}

