/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import java.util.Arrays;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.CompositeTagListener;
import org.zalando.opentracing.proxy.Plugin;
import org.zalando.opentracing.proxy.Registry;

@API(status=API.Status.MAINTAINED)
public interface TagListener
extends Plugin {
    default public <T> void onTag(Tracer.SpanBuilder builder, Tag<T> tag, T value) {
    }

    default public <T> void onTag(Span span, Tag<T> tag, T value) {
    }

    @Override
    default public <R extends Registry<R>> R registerTo(R registry) {
        return registry.withTagListener(this);
    }

    public static TagListener composite(TagListener ... listeners) {
        return TagListener.composite(Arrays.asList(listeners));
    }

    public static TagListener composite(Iterable<TagListener> listeners) {
        return new CompositeTagListener(listeners);
    }
}

