/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy.base;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tag;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.base.NormalizingSpan;

@API(status=API.Status.EXPERIMENTAL)
public interface ForwardingSpan
extends NormalizingSpan {
    public Span delegate();

    default public SpanContext context() {
        return this.delegate().context();
    }

    default public <T> Span setTag(Tag<T> tag, T value) {
        this.delegate().setTag(tag, value);
        return this;
    }

    default public Span log(Map<String, ?> fields) {
        this.delegate().log(fields);
        return this;
    }

    default public Span log(long timestampMicroseconds, Map<String, ?> fields) {
        this.delegate().log(timestampMicroseconds, fields);
        return this;
    }

    default public Span log(String event) {
        this.delegate().log(event);
        return this;
    }

    default public Span log(long timestampMicroseconds, String event) {
        this.delegate().log(timestampMicroseconds, event);
        return this;
    }

    default public Span setBaggageItem(String key, String value) {
        this.delegate().setBaggageItem(key, value);
        return this;
    }

    default public String getBaggageItem(String key) {
        return this.delegate().getBaggageItem(key);
    }

    default public Span setOperationName(String operationName) {
        this.delegate().setOperationName(operationName);
        return this;
    }

    default public void finish() {
        this.delegate().finish();
    }

    default public void finish(long finishMicros) {
        this.delegate().finish(finishMicros);
    }

    public static Span unwrap(Span span) {
        return Optional.of(span).filter(ForwardingSpan.class::isInstance).map(ForwardingSpan.class::cast).map(ForwardingSpan::delegate).map(ForwardingSpan::unwrap).orElse(span);
    }

    public static <S> Optional<S> unwrap(@Nullable Span span, Class<S> type) {
        if (type.isInstance(span)) {
            return Optional.of(type.cast(span));
        }
        return Optional.ofNullable(span).filter(ForwardingSpan.class::isInstance).map(ForwardingSpan.class::cast).map(ForwardingSpan::delegate).flatMap(s -> ForwardingSpan.unwrap(s, type));
    }
}

