/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy.plugin;

import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.listen.baggage.BaggageListener;
import org.zalando.opentracing.proxy.listen.span.SpanListener;

@API(status=API.Status.EXPERIMENTAL)
public final class AutoTagging
implements SpanListener,
BaggageListener {
    private final Map<String, String> mapping;

    public AutoTagging(String key) {
        this(key, key);
    }

    public AutoTagging(String baggageKey, String tagKey) {
        this(Collections.singletonMap(baggageKey, tagKey));
    }

    @Override
    public void onStarted(Span span) {
        this.mapping.forEach((baggageKey, tagKey) -> Optional.ofNullable(span.getBaggageItem(baggageKey)).ifPresent(value -> span.setTag(tagKey, value)));
    }

    @Override
    public void onBaggage(Tracer tracer, Span span, String key, String value) {
        Optional.ofNullable(this.mapping.get(key)).ifPresent(tagKey -> span.setTag(tagKey, value));
    }

    @Generated
    public AutoTagging(Map<String, String> mapping) {
        this.mapping = mapping;
    }
}

