/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy.core;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import lombok.Generated;
import org.zalando.opentracing.proxy.core.Plugins;
import org.zalando.opentracing.proxy.intercept.baggage.BaggageInterceptor;
import org.zalando.opentracing.proxy.intercept.injection.Injection;
import org.zalando.opentracing.proxy.intercept.log.LogInterceptor;
import org.zalando.opentracing.proxy.intercept.name.Naming;
import org.zalando.opentracing.proxy.intercept.span.SpanBuilderInterceptor;
import org.zalando.opentracing.proxy.intercept.tag.TagInterceptor;
import org.zalando.opentracing.proxy.listen.baggage.BaggageListener;
import org.zalando.opentracing.proxy.listen.log.LogListener;
import org.zalando.opentracing.proxy.listen.scope.ScopeListener;
import org.zalando.opentracing.proxy.listen.span.SpanListener;
import org.zalando.opentracing.proxy.listen.tag.TagListener;
import org.zalando.opentracing.proxy.spi.Plugin;
import org.zalando.opentracing.proxy.spi.Registry;

final class PluginRegistry
implements Registry,
Plugins {
    private static final Map<Class<? extends Plugin>, Reducer<? extends Plugin>> reducers = ImmutableMap.builder().put(Naming.class, PluginRegistry.reduce(Naming.DEFAULT, (left, right) -> right)).put(SpanBuilderInterceptor.class, PluginRegistry.reduce(SpanBuilderInterceptor.DEFAULT, (xva$0, xva$1) -> SpanBuilderInterceptor.composite(xva$0, xva$1))).put(TagInterceptor.class, PluginRegistry.reduce(TagInterceptor.DEFAULT, (xva$0, xva$1) -> TagInterceptor.composite(xva$0, xva$1))).put(LogInterceptor.class, PluginRegistry.reduce(LogInterceptor.DEFAULT, (xva$0, xva$1) -> LogInterceptor.composite(xva$0, xva$1))).put(BaggageInterceptor.class, PluginRegistry.reduce(BaggageInterceptor.DEFAULT, (xva$0, xva$1) -> BaggageInterceptor.composite(xva$0, xva$1))).put(Injection.class, PluginRegistry.reduce(Injection.DEFAULT, (xva$0, xva$1) -> Injection.composite(xva$0, xva$1))).put(SpanListener.class, PluginRegistry.reduce(SpanListener.DEFAULT, (xva$0, xva$1) -> SpanListener.composite(xva$0, xva$1))).put(TagListener.class, PluginRegistry.reduce(TagListener.DEFAULT, (xva$0, xva$1) -> TagListener.composite(xva$0, xva$1))).put(LogListener.class, PluginRegistry.reduce(LogListener.DEFAULT, (xva$0, xva$1) -> LogListener.composite(xva$0, xva$1))).put(BaggageListener.class, PluginRegistry.reduce(BaggageListener.DEFAULT, (xva$0, xva$1) -> BaggageListener.composite(xva$0, xva$1))).put(ScopeListener.class, PluginRegistry.reduce(ScopeListener.DEFAULT, (xva$0, xva$1) -> ScopeListener.composite(xva$0, xva$1))).build();
    private final ClassToInstanceMap<Plugin> plugins;
    private final Plugins.Interceptors interceptors = new MyInterceptors();
    private final Plugins.Listeners listeners = new MyListeners();

    PluginRegistry() {
        this((ClassToInstanceMap<Plugin>)ImmutableClassToInstanceMap.of());
    }

    private static <P extends Plugin> Reducer<P> reduce(P seed, BinaryOperator<P> merge) {
        return plugins -> plugins.stream().reduce(merge).orElse(seed);
    }

    @Override
    public PluginRegistry register(Plugin plugin) {
        HashMap result = new HashMap(this.plugins);
        reducers.forEach((type, raw) -> {
            if (type.isInstance(plugin)) {
                Reducer reducer = raw;
                result.merge(type, plugin, reducer::reduce);
            }
        });
        return new PluginRegistry((ClassToInstanceMap<Plugin>)ImmutableClassToInstanceMap.copyOf(result));
    }

    @Override
    public Plugins.Interceptors interceptors() {
        return this.interceptors;
    }

    @Override
    public Plugins.Listeners listeners() {
        return this.listeners;
    }

    private <P extends Plugin> P plugin(Class<P> type, P defaultValue) {
        Plugin instance = (Plugin)this.plugins.getInstance(type);
        return (P)(instance == null ? defaultValue : instance);
    }

    @Generated
    public PluginRegistry(ClassToInstanceMap<Plugin> plugins) {
        this.plugins = plugins;
    }

    private final class MyListeners
    implements Plugins.Listeners {
        private MyListeners() {
        }

        @Override
        public SpanListener spans() {
            return (SpanListener)PluginRegistry.this.plugin(SpanListener.class, SpanListener.DEFAULT);
        }

        @Override
        public TagListener tags() {
            return (TagListener)PluginRegistry.this.plugin(TagListener.class, TagListener.DEFAULT);
        }

        @Override
        public LogListener logs() {
            return (LogListener)PluginRegistry.this.plugin(LogListener.class, LogListener.DEFAULT);
        }

        @Override
        public BaggageListener baggage() {
            return (BaggageListener)PluginRegistry.this.plugin(BaggageListener.class, BaggageListener.DEFAULT);
        }

        @Override
        public ScopeListener scopes() {
            return (ScopeListener)PluginRegistry.this.plugin(ScopeListener.class, ScopeListener.DEFAULT);
        }
    }

    private class MyInterceptors
    implements Plugins.Interceptors {
        private MyInterceptors() {
        }

        @Override
        public Naming names() {
            return (Naming)PluginRegistry.this.plugin(Naming.class, Naming.DEFAULT);
        }

        @Override
        public SpanBuilderInterceptor spans() {
            return (SpanBuilderInterceptor)PluginRegistry.this.plugin(SpanBuilderInterceptor.class, SpanBuilderInterceptor.DEFAULT);
        }

        @Override
        public TagInterceptor tags() {
            return (TagInterceptor)PluginRegistry.this.plugin(TagInterceptor.class, TagInterceptor.DEFAULT);
        }

        @Override
        public LogInterceptor logs() {
            return (LogInterceptor)PluginRegistry.this.plugin(LogInterceptor.class, LogInterceptor.DEFAULT);
        }

        @Override
        public BaggageInterceptor baggage() {
            return (BaggageInterceptor)PluginRegistry.this.plugin(BaggageInterceptor.class, BaggageInterceptor.DEFAULT);
        }

        @Override
        public Injection injections() {
            return (Injection)PluginRegistry.this.plugin(Injection.class, Injection.DEFAULT);
        }
    }

    @FunctionalInterface
    private static interface Reducer<P extends Plugin> {
        default public P reduce(P left, P right) {
            return (P)this.reduce(Arrays.asList(left, right));
        }

        public P reduce(Collection<P> var1);
    }
}

