/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy.intercept.tag;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.CheckReturnValue;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.intercept.tag.CompositeTagInterceptor;
import org.zalando.opentracing.proxy.intercept.tag.DefaultTagPair;
import org.zalando.opentracing.proxy.listen.tag.TagListener;
import org.zalando.opentracing.proxy.spi.Plugin;

@API(status=API.Status.EXPERIMENTAL)
public interface TagInterceptor
extends Plugin {
    public static final TagInterceptor DEFAULT = new TagInterceptor(){};

    @CheckReturnValue
    default public <T> Collection<TagPair> intercept(Tag<T> tag, T value) {
        return Collections.singleton(TagPair.of(tag, value));
    }

    public static TagInterceptor composite(TagInterceptor ... interceptors) {
        return TagInterceptor.composite(Arrays.asList(interceptors));
    }

    public static TagInterceptor composite(Collection<TagInterceptor> interceptors) {
        return new CompositeTagInterceptor(interceptors);
    }

    public static interface TagPair {
        public void tag(Tracer.SpanBuilder var1);

        public void notify(TagListener var1, Tracer.SpanBuilder var2);

        public void tag(Span var1);

        public void notify(TagListener var1, Span var2);

        public static <T> TagPair of(Tag<T> tag, T value) {
            return new DefaultTagPair<T>(tag, value);
        }
    }
}

