/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy.intercept.injection;

import io.opentracing.SpanContext;
import io.opentracing.propagation.Format;
import java.util.Arrays;
import javax.annotation.CheckReturnValue;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.intercept.injection.CompositeInjection;
import org.zalando.opentracing.proxy.intercept.injection.NoopInjector;
import org.zalando.opentracing.proxy.spi.Plugin;

@API(status=API.Status.EXPERIMENTAL)
public interface Injection
extends Plugin {
    public static final Injection DEFAULT = (injector, context, format) -> injector;
    public static final Injection DISABLE = (injector, context, format) -> Injector.NOOP;

    @CheckReturnValue
    public Injector intercept(Injector var1, SpanContext var2, Format<?> var3);

    public static Injection composite(Injection ... interceptors) {
        return Injection.composite(Arrays.asList(interceptors));
    }

    public static Injection composite(Iterable<Injection> interceptors) {
        return new CompositeInjection(interceptors);
    }

    public static interface Injector {
        public static final Injector NOOP = NoopInjector.NOOP;

        public <C> void inject(SpanContext var1, Format<C> var2, C var3);
    }
}

