/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy.intercept.log;

import io.opentracing.Span;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.intercept.log.CompositeLogInterceptor;
import org.zalando.opentracing.proxy.intercept.log.DefaultLog;
import org.zalando.opentracing.proxy.listen.log.LogListener;
import org.zalando.opentracing.proxy.spi.Plugin;

@API(status=API.Status.EXPERIMENTAL)
public interface LogInterceptor
extends Plugin {
    public static final LogInterceptor DEFAULT = new LogInterceptor(){};

    @CheckReturnValue
    default public Collection<Log> intercept(Span span, long timestamp, Map<String, ?> fields) {
        return Collections.singleton(Log.of(timestamp, fields));
    }

    @CheckReturnValue
    default public Collection<Log> intercept(Span span, Map<String, ?> fields) {
        return Collections.singleton(Log.of(fields));
    }

    public static LogInterceptor composite(LogInterceptor ... interceptors) {
        return LogInterceptor.composite(Arrays.asList(interceptors));
    }

    public static LogInterceptor composite(Collection<LogInterceptor> interceptors) {
        return new CompositeLogInterceptor(interceptors);
    }

    public static interface Log {
        public void log(Span var1);

        public void notify(LogListener var1, Span var2);

        public static Log of(long timestamp, Map<String, ?> fields) {
            return new DefaultLog(span -> span.log(timestamp, fields), (listener, span) -> listener.onLog((Span)span, timestamp, fields));
        }

        public static Log of(Map<String, ?> fields) {
            return new DefaultLog(span -> span.log(fields), (listener, span) -> listener.onLog((Span)span, fields));
        }
    }
}

