/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy.plugin;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.base.ForwardingSpan;
import org.zalando.opentracing.proxy.base.ForwardingSpanBuilder;
import org.zalando.opentracing.proxy.intercept.span.SpanBuilderInterceptor;

@API(status=API.Status.EXPERIMENTAL)
public final class TagPropagation
implements SpanBuilderInterceptor {
    private final Set<String> keys;

    public TagPropagation(String ... keys) {
        this(Arrays.asList(keys));
    }

    public TagPropagation(List<String> keys) {
        this(new HashSet<String>(keys));
    }

    @Override
    public Tracer.SpanBuilder intercept(Tracer tracer, Tracer.SpanBuilder builder) {
        return new PropagatingSpanBuilder(tracer, builder);
    }

    private static <T> void propagate(Map<Tag<?>, Object> tags, BiConsumer<Tag<T>, T> consumer) {
        tags.forEach((raw, value) -> {
            Tag tag = raw;
            consumer.accept(tag, value);
        });
    }

    @Generated
    public TagPropagation(Set<String> keys) {
        this.keys = keys;
    }

    private final class PropagatingSpan
    implements ForwardingSpan {
        private final Span delegate;
        private final Map<Tag<?>, Object> tags;

        PropagatingSpan(Span delegate) {
            this(delegate, new HashMap());
        }

        @Override
        public Span delegate() {
            return this.delegate;
        }

        @Override
        public <T> Span setTag(Tag<T> tag, T value) {
            this.set(tag, value);
            return this.delegate.setTag(tag, value);
        }

        private <T> void set(Tag<T> tag, T value) {
            if (TagPropagation.this.keys.contains(tag.getKey())) {
                this.tags.put(tag, value);
            }
        }

        void propagateTo(Tracer.SpanBuilder builder) {
            TagPropagation.propagate(this.tags, (arg_0, arg_1) -> ((Tracer.SpanBuilder)builder).withTag(arg_0, arg_1));
        }

        void propagateTo(Span span) {
            TagPropagation.propagate(this.tags, (arg_0, arg_1) -> ((Span)span).setTag(arg_0, arg_1));
        }

        @Generated
        private PropagatingSpan(Span delegate, Map<Tag<?>, Object> tags) {
            this.delegate = delegate;
            this.tags = tags;
        }
    }

    private final class PropagatingSpanBuilder
    implements ForwardingSpanBuilder {
        private final Tracer tracer;
        private final Tracer.SpanBuilder delegate;
        private final Map<Tag<?>, Object> tags = new HashMap();
        private boolean ignoreActiveSpan;

        @Override
        public Tracer.SpanBuilder delegate() {
            return this.delegate;
        }

        @Override
        public <T> Tracer.SpanBuilder withTag(Tag<T> tag, T value) {
            this.with(tag, value);
            return ForwardingSpanBuilder.super.withTag(tag, value);
        }

        private <T> void with(Tag<T> tag, T value) {
            if (TagPropagation.this.keys.contains(tag.getKey())) {
                this.tags.put(tag, value);
            }
        }

        @Override
        public Tracer.SpanBuilder asChildOf(@Nullable Span parent) {
            ForwardingSpan.unwrap(parent, PropagatingSpan.class).ifPresent(span -> span.propagateTo(this));
            return ForwardingSpanBuilder.super.asChildOf(parent);
        }

        @Override
        public Tracer.SpanBuilder ignoreActiveSpan() {
            this.ignoreActiveSpan = true;
            return ForwardingSpanBuilder.super.ignoreActiveSpan();
        }

        @Override
        public Span start() {
            PropagatingSpan span = new PropagatingSpan(this.delegate.start());
            TagPropagation.propagate(this.tags, (arg_0, arg_1) -> ((Span)span).setTag(arg_0, arg_1));
            if (this.ignoreActiveSpan) {
                return span;
            }
            Span active = this.tracer.activeSpan();
            ForwardingSpan.unwrap(active, PropagatingSpan.class).ifPresent(parent -> parent.propagateTo(span));
            return span;
        }

        @Generated
        private PropagatingSpanBuilder(Tracer tracer, Tracer.SpanBuilder delegate) {
            this.tracer = tracer;
            this.delegate = delegate;
        }
    }
}

