/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy.core;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.zalando.opentracing.proxy.base.ForwardingSpan;
import org.zalando.opentracing.proxy.core.Plugins;
import org.zalando.opentracing.proxy.intercept.baggage.BaggageInterceptor;
import org.zalando.opentracing.proxy.intercept.log.LogInterceptor;
import org.zalando.opentracing.proxy.intercept.tag.TagInterceptor;
import org.zalando.opentracing.proxy.listen.baggage.BaggageListener;
import org.zalando.opentracing.proxy.listen.log.LogListener;
import org.zalando.opentracing.proxy.listen.span.SpanListener;
import org.zalando.opentracing.proxy.listen.tag.TagListener;

final class ProxySpan
implements ForwardingSpan {
    private final Tracer tracer;
    private final Span delegate;
    private final Plugins plugins;

    @Override
    public Span delegate() {
        return this.delegate;
    }

    @Override
    public <T> Span setTag(Tag<T> tag, T value) {
        TagInterceptor interceptor = this.plugins.interceptors().tags();
        TagListener listener = this.plugins.listeners().tags();
        interceptor.intercept(tag, value).forEach(pair -> {
            pair.tag(this.delegate);
            pair.notify(listener, this);
        });
        return this;
    }

    @Override
    public Span log(Map<String, ?> fields) {
        LogInterceptor interceptor = this.plugins.interceptors().logs();
        LogListener listener = this.plugins.listeners().logs();
        interceptor.intercept(this, fields).forEach(log -> {
            log.log(this.delegate);
            log.notify(listener, this);
        });
        return this;
    }

    @Override
    public Span log(long timestamp, Map<String, ?> fields) {
        LogInterceptor interceptor = this.plugins.interceptors().logs();
        LogListener listener = this.plugins.listeners().logs();
        interceptor.intercept(this, timestamp, fields).forEach(log -> {
            log.log(this.delegate);
            log.notify(listener, this);
        });
        return this;
    }

    @Override
    public Span log(String event) {
        return this.log(Collections.singletonMap("event", event));
    }

    @Override
    public Span log(long timestamp, String event) {
        return this.log(timestamp, Collections.singletonMap("event", event));
    }

    @Override
    public Span setBaggageItem(String key, String value) {
        BaggageInterceptor interceptor = this.plugins.interceptors().baggage();
        interceptor.intercept(this, key, value).forEach(this::bag);
        return this;
    }

    private void bag(String key, String value) {
        BaggageListener listener = this.plugins.listeners().baggage();
        ForwardingSpan.super.setBaggageItem(key, value);
        listener.onBaggage(this.tracer, this, key, value);
    }

    @Override
    public Span setOperationName(String operationName) {
        return ForwardingSpan.super.setOperationName(this.plugins.interceptors().names().rename(operationName));
    }

    @Override
    public void finish() {
        SpanListener listener = this.plugins.listeners().spans();
        listener.onFinishing(this);
        ForwardingSpan.super.finish();
        listener.onFinished(this);
    }

    @Override
    public void finish(long finishMicros) {
        SpanListener listener = this.plugins.listeners().spans();
        listener.onFinishing(this);
        ForwardingSpan.super.finish(finishMicros);
        listener.onFinished(this);
    }

    @Generated
    public ProxySpan(Tracer tracer, Span delegate, Plugins plugins) {
        this.tracer = tracer;
        this.delegate = delegate;
        this.plugins = plugins;
    }
}

