/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy.core;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import javax.annotation.Nullable;
import lombok.Generated;
import org.zalando.opentracing.proxy.base.ForwardingSpan;
import org.zalando.opentracing.proxy.base.ForwardingSpanBuilder;
import org.zalando.opentracing.proxy.core.Plugins;
import org.zalando.opentracing.proxy.core.ProxySpan;
import org.zalando.opentracing.proxy.intercept.tag.TagInterceptor;
import org.zalando.opentracing.proxy.listen.tag.TagListener;

final class ProxySpanBuilder
implements ForwardingSpanBuilder {
    private final Tracer tracer;
    private final Tracer.SpanBuilder delegate;
    private final Plugins plugins;

    @Override
    public Tracer.SpanBuilder delegate() {
        return this.delegate;
    }

    @Override
    public Tracer.SpanBuilder asChildOf(@Nullable Span parent) {
        if (parent == null) {
            return this;
        }
        return ForwardingSpanBuilder.super.asChildOf(ForwardingSpan.unwrap(parent));
    }

    @Override
    public <T> Tracer.SpanBuilder withTag(Tag<T> tag, T value) {
        TagInterceptor interceptor = this.plugins.interceptors().tags();
        TagListener listener = this.plugins.listeners().tags();
        interceptor.intercept(tag, value).forEach(pair -> {
            pair.tag(this.delegate);
            pair.notify(listener, this);
        });
        return this;
    }

    @Override
    public Span start() {
        ProxySpan span = new ProxySpan(this.tracer, this.delegate.start(), this.plugins);
        this.plugins.listeners().spans().onStarted(span);
        return span;
    }

    @Generated
    public ProxySpanBuilder(Tracer tracer, Tracer.SpanBuilder delegate, Plugins plugins) {
        this.tracer = tracer;
        this.delegate = delegate;
        this.plugins = plugins;
    }
}

