/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy.intercept.baggage;

import io.opentracing.Span;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.intercept.baggage.CompositeBaggageInterceptor;
import org.zalando.opentracing.proxy.spi.Plugin;

@API(status=API.Status.EXPERIMENTAL)
public interface BaggageInterceptor
extends Plugin {
    public static final BaggageInterceptor DEFAULT = new BaggageInterceptor(){};

    @CheckReturnValue
    default public Map<String, String> intercept(Span span, String key, String value) {
        return Collections.singletonMap(key, value);
    }

    public static BaggageInterceptor composite(BaggageInterceptor ... interceptors) {
        return BaggageInterceptor.composite(Arrays.asList(interceptors));
    }

    public static BaggageInterceptor composite(Collection<BaggageInterceptor> interceptors) {
        return new CompositeBaggageInterceptor(interceptors);
    }
}

