/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy.core;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.opentracing.proxy.base.ForwardingTracer;
import org.zalando.opentracing.proxy.core.PluginRegistry;
import org.zalando.opentracing.proxy.core.ProxyScope;
import org.zalando.opentracing.proxy.core.ProxyScopeManager;
import org.zalando.opentracing.proxy.core.ProxySpan;
import org.zalando.opentracing.proxy.core.ProxySpanBuilder;
import org.zalando.opentracing.proxy.spi.Plugin;

@API(status=API.Status.EXPERIMENTAL)
public final class ProxyTracer
implements ForwardingTracer {
    private final Tracer delegate;
    private final PluginRegistry registry;

    public ProxyTracer(Tracer tracer) {
        this(tracer, new PluginRegistry());
    }

    @Override
    public Tracer delegate() {
        return this.delegate;
    }

    public ProxyTracer with(Plugin plugin) {
        return new ProxyTracer(this.delegate, this.registry.register(plugin));
    }

    @Override
    public <C> void inject(SpanContext context, Format<C> format, C carrier) {
        this.registry.interceptors().injections().intercept((x$0, x$1, x$2) -> ForwardingTracer.super.inject(x$0, x$1, x$2), context, format).inject(context, format, carrier);
    }

    @Override
    public Tracer.SpanBuilder buildSpan(String operationName) {
        Tracer.SpanBuilder builder = ForwardingTracer.super.buildSpan(this.registry.interceptors().names().rename(operationName));
        return this.registry.interceptors().spans().intercept(this, new ProxySpanBuilder(this, builder, this.registry));
    }

    @Override
    public ScopeManager scopeManager() {
        return new ProxyScopeManager(ForwardingTracer.super.scopeManager(), this.registry);
    }

    @Override
    public Scope activateSpan(@Nullable Span span) {
        if (span == null) {
            return ForwardingTracer.super.activateSpan(null);
        }
        Scope original = ForwardingTracer.super.activateSpan(span);
        ProxyScope scope = new ProxyScope(original, span, this.registry);
        this.registry.listeners().scopes().onActivated(scope, span);
        return scope;
    }

    @Override
    public Span activeSpan() {
        Span span = ForwardingTracer.super.activeSpan();
        if (span == null || span instanceof ProxySpan) {
            return span;
        }
        return new ProxySpan(this, span, this.registry);
    }

    @Generated
    private ProxyTracer(Tracer delegate, PluginRegistry registry) {
        this.delegate = delegate;
        this.registry = registry;
    }
}

