/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.proxy.plugin;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.MDC;
import org.zalando.opentracing.proxy.listen.baggage.BaggageListener;
import org.zalando.opentracing.proxy.listen.scope.ScopeListener;

@API(status=API.Status.EXPERIMENTAL)
public final class LogCorrelation
implements ScopeListener,
BaggageListener {
    private final ThreadLocal<Deque<Map<String, String>>> contexts = ThreadLocal.withInitial(LinkedList::new);
    private final ImmutableMap<Seed, String> seeds;
    private final ImmutableMap<String, String> baggage;

    public LogCorrelation() {
        this((ImmutableMap<Seed, String>)ImmutableMap.of(), (ImmutableMap<String, String>)ImmutableMap.of());
    }

    public LogCorrelation withTraceId(String contextKey) {
        Seed seed = span -> span.context().toTraceId();
        return new LogCorrelation(LogCorrelation.assoc(this.seeds, seed, contextKey), this.baggage);
    }

    public LogCorrelation withSpanId(String contextKey) {
        Seed seed = span -> span.context().toSpanId();
        return new LogCorrelation(LogCorrelation.assoc(this.seeds, seed, contextKey), this.baggage);
    }

    public LogCorrelation withBaggage(String key) {
        return this.withBaggage(Collections.singleton(key));
    }

    public LogCorrelation withBaggage(Collection<String> keys) {
        return this.withBaggage(keys.stream().collect(Collectors.toMap(Function.identity(), Function.identity())));
    }

    public LogCorrelation withBaggage(String baggageKey, String contextKey) {
        return this.withBaggage(Collections.singletonMap(baggageKey, contextKey));
    }

    public LogCorrelation withBaggage(Map<String, String> mapping) {
        return new LogCorrelation((ImmutableMap<Seed, String>)LogCorrelation.reduce(mapping.entrySet(), this.seeds, (seeds, e) -> LogCorrelation.assoc(seeds, LogCorrelation.baggageSeed((String)e.getKey()), (String)e.getValue())), (ImmutableMap<String, String>)LogCorrelation.reduce(mapping.entrySet(), this.baggage, LogCorrelation::assoc));
    }

    @Override
    public void onActivated(Scope scope, Span span) {
        this.contexts.get().push(this.preserveContext());
        this.seeds.forEach((seed, contextKey) -> Optional.ofNullable(seed.valueOf(span)).ifPresent(value -> MDC.put((String)contextKey, (String)value)));
    }

    private Map<String, String> preserveContext() {
        HashMap context = Maps.newHashMapWithExpectedSize((int)(this.seeds.size() + this.baggage.size()));
        this.contextKeys().forEach(contextKey -> {
            String value = MDC.get((String)contextKey);
            if (value == null) {
                return;
            }
            context.put(contextKey, value);
        });
        return context;
    }

    @Override
    public void onBaggage(Tracer tracer, Span span, String baggageKey, String value) {
        Function<Span, String> toSpanId = s -> s.context().toSpanId();
        String activeSpanId = Optional.ofNullable(tracer.activeSpan()).map(toSpanId).orElse(null);
        if (toSpanId.apply(span).equals(activeSpanId)) {
            Optional.ofNullable((String)this.baggage.get((Object)baggageKey)).ifPresent(contextKey -> MDC.put((String)contextKey, (String)value));
        }
    }

    @Override
    public void onClosing(Scope scope, Span span) {
        Map<String, String> previousContext = this.restoreContext();
        this.contextKeys().forEach(key -> {
            String value = (String)previousContext.get(key);
            if (value == null) {
                MDC.remove((String)key);
            } else {
                MDC.put((String)key, (String)value);
            }
        });
    }

    private static <K, V> ImmutableMap<K, V> assoc(ImmutableMap<K, V> map, Map.Entry<K, V> entry) {
        return LogCorrelation.assoc(map, entry.getKey(), entry.getValue());
    }

    private static <K, V> ImmutableMap<K, V> assoc(ImmutableMap<K, V> map, K key, V value) {
        return ImmutableMap.builder().putAll(map).put(key, value).build();
    }

    private static Seed baggageSeed(String key) {
        return span -> span.getBaggageItem(key);
    }

    private static <E, R> R reduce(Iterable<E> elements, R identity, BiFunction<R, E, R> accumulator) {
        R result = identity;
        for (E element : elements) {
            result = accumulator.apply(result, element);
        }
        return result;
    }

    private Map<String, String> restoreContext() {
        return Optional.ofNullable(this.contexts.get().poll()).orElse(Collections.emptyMap());
    }

    private Stream<String> contextKeys() {
        return Stream.concat(this.seeds.values().stream(), this.baggage.values().stream());
    }

    @Generated
    private LogCorrelation(ImmutableMap<Seed, String> seeds, ImmutableMap<String, String> baggage) {
        this.seeds = seeds;
        this.baggage = baggage;
    }

    @FunctionalInterface
    private static interface Seed {
        @Nullable
        public String valueOf(Span var1);
    }
}

