/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.servlet.extension;

import io.opentracing.Span;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.fauxpas.FauxPas;
import org.zalando.opentracing.servlet.extension.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class ErrorSpanDecorator
implements SpanDecorator {
    private final Predicate<HttpServletResponse> predicate;

    public ErrorSpanDecorator() {
        this((Predicate<HttpServletResponse>)FauxPas.throwingPredicate(response -> response.getStatus() >= 500));
    }

    @Override
    public void onResponse(HttpServletRequest request, HttpServletResponse response, Span span) {
        if (this.predicate.test(response)) {
            span.setTag((Tag)Tags.ERROR, (Object)true);
        }
    }

    @Override
    public void onError(HttpServletRequest request, HttpServletResponse response, Throwable error, Span span) {
        span.setTag((Tag)Tags.ERROR, (Object)true);
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("error.kind", error.getClass().getSimpleName());
        fields.put("error.object", error);
        span.log(fields);
    }

    @Generated
    public ErrorSpanDecorator(Predicate<HttpServletResponse> predicate) {
        this.predicate = predicate;
    }
}

