/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.servlet.extension;

import io.opentracing.Span;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import javax.servlet.http.HttpServletRequest;
import org.apiguardian.api.API;
import org.zalando.opentracing.servlet.extension.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class PeerSpanDecorator
implements SpanDecorator {
    @API(status=API.Status.EXPERIMENTAL)
    private static final Tag<String> PEER_ADDRESS = new StringTag("peer.address");
    @API(status=API.Status.INTERNAL)
    private static final Tag<String> PEER_HOST_IPV4 = new StringTag("peer.ipv4");

    @Override
    public void onRequest(HttpServletRequest request, Span span) {
        String ip = request.getRemoteAddr();
        String hostname = request.getRemoteHost();
        int port = request.getRemotePort();
        span.setTag(PEER_ADDRESS, (Object)(hostname + ":" + port));
        span.setTag((Tag)Tags.PEER_PORT, (Object)port);
        if (!ip.equals(hostname)) {
            span.setTag((Tag)Tags.PEER_HOSTNAME, (Object)hostname);
        }
        if (this.isProbablyIPv6(ip)) {
            span.setTag((Tag)Tags.PEER_HOST_IPV6, (Object)ip);
        } else {
            span.setTag(PEER_HOST_IPV4, (Object)ip);
        }
    }

    private boolean isProbablyIPv6(String ip) {
        return ip.contains(":");
    }
}

