/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.servlet.extension;

import io.opentracing.Span;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apiguardian.api.API;
import org.zalando.opentracing.servlet.extension.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class HttpUrlSpanDecorator
implements SpanDecorator {
    @Override
    public void onRequest(HttpServletRequest request, Span span) {
        StringBuffer url = request.getRequestURL();
        Optional.ofNullable(request.getQueryString()).ifPresent(query -> url.append("?").append((String)query));
        span.setTag((Tag)Tags.HTTP_URL, (Object)url.toString());
    }
}

