/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.servlet.extension;

import io.opentracing.Span;
import io.opentracing.contrib.web.servlet.filter.ServletFilterSpanDecorator;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class CompositeSpanDecorator
implements ServletFilterSpanDecorator {
    private final Iterable<ServletFilterSpanDecorator> decorators;

    public void onRequest(HttpServletRequest request, Span span) {
        this.decorators.forEach(decorator -> decorator.onRequest(request, span));
    }

    public void onResponse(HttpServletRequest request, HttpServletResponse response, Span span) {
        this.decorators.forEach(decorator -> decorator.onResponse(request, response, span));
    }

    public void onError(HttpServletRequest request, HttpServletResponse response, Throwable throwable, Span span) {
        this.decorators.forEach(decorator -> decorator.onError(request, response, throwable, span));
    }

    public void onTimeout(HttpServletRequest request, HttpServletResponse response, long timeout, Span span) {
        this.decorators.forEach(decorator -> decorator.onTimeout(request, response, timeout, span));
    }

    static ServletFilterSpanDecorator composite(ServletFilterSpanDecorator ... decorators) {
        return CompositeSpanDecorator.composite(Arrays.asList(decorators));
    }

    static ServletFilterSpanDecorator composite(Iterable<ServletFilterSpanDecorator> decorators) {
        return new CompositeSpanDecorator(decorators);
    }

    @Generated
    public CompositeSpanDecorator(Iterable<ServletFilterSpanDecorator> decorators) {
        this.decorators = decorators;
    }
}

