/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.opentracing.servlet.extension;

import io.opentracing.Span;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tag;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apiguardian.api.API;
import org.zalando.opentracing.servlet.extension.SpanDecorator;

@API(status=API.Status.EXPERIMENTAL)
public final class HttpRetryAfterSpanDecorator
implements SpanDecorator {
    private static final Tag<String> RETRY_AFTER = new StringTag("http.retry_after");

    @Override
    public void onResponse(HttpServletRequest request, HttpServletResponse response, Span span) {
        Optional.ofNullable(response.getHeader("Retry-After")).ifPresent(retryAfter -> span.setTag(RETRY_AFTER, retryAfter));
    }
}

