/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.zalando.paradox.nakadi.consumer.boot.EventReceiverRegistryConfiguration;
import de.zalando.paradox.nakadi.consumer.boot.NakadiConsumerProperties;
import de.zalando.paradox.nakadi.consumer.core.AuthorizationValueProvider;
import de.zalando.paradox.nakadi.consumer.core.client.Client;
import de.zalando.paradox.nakadi.consumer.core.client.impl.ClientImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={NakadiConsumerProperties.class})
public class ClientConfiguration {
    @Autowired
    private NakadiConsumerProperties nakadiConsumerProperties;
    @Autowired(required=false)
    private AuthorizationValueProvider authorizationValueProvider;
    @Autowired(required=false)
    @Qualifier(value="nakadiObjectMapper")
    private ObjectMapper objectMapper;

    @Bean
    public Client nakadiClient(EventReceiverRegistryConfiguration eventReceiverConfig) {
        ClientImpl.Builder builder = new ClientImpl.Builder(this.nakadiConsumerProperties.getNakadiUrl());
        if (null != this.authorizationValueProvider) {
            builder.withAuthorization(this.authorizationValueProvider);
        }
        if (null != this.objectMapper) {
            builder.withObjectMapper(this.objectMapper);
        }
        return builder.build();
    }
}

