/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.zalando.paradox.nakadi.consumer.boot.NakadiConsumerProperties;
import de.zalando.paradox.nakadi.consumer.boot.components.ConsumerEventConfigList;
import de.zalando.paradox.nakadi.consumer.boot.components.ConsumerPartitionCoordinatorProvider;
import de.zalando.paradox.nakadi.consumer.boot.components.EventReceiverRegistry;
import de.zalando.paradox.nakadi.consumer.core.AuthorizationValueProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={NakadiConsumerProperties.class})
public class EventReceiverRegistryConfiguration {
    @Autowired
    private NakadiConsumerProperties nakadiConsumerProperties;
    @Autowired
    private ConsumerPartitionCoordinatorProvider coordinatorProvider;
    @Autowired
    private ConsumerEventConfigList consumerEventConfigList;
    @Autowired(required=false)
    private AuthorizationValueProvider authorizationValueProvider;
    @Autowired(required=false)
    @Qualifier(value="nakadiObjectMapper")
    private ObjectMapper objectMapper;

    public ConsumerPartitionCoordinatorProvider getCoordinatorProvider() {
        return this.coordinatorProvider;
    }

    public ConsumerEventConfigList getConsumerEventConfigList() {
        return this.consumerEventConfigList;
    }

    public AuthorizationValueProvider getAuthorizationValueProvider() {
        return this.authorizationValueProvider;
    }

    public String getNakadiUrl() {
        return this.nakadiConsumerProperties.getNakadiUrl();
    }

    public boolean isEventTypePartitionCoordinator() {
        return this.nakadiConsumerProperties.isEventTypePartitionCoordinator();
    }

    public Long getPartitionsRetryAfterMillis() {
        return this.nakadiConsumerProperties.getPartitionsRetryAfterMillis();
    }

    public Long getPartitionsRetryRandomMillis() {
        return this.nakadiConsumerProperties.getPartitionsRetryRandomMillis();
    }

    public Long getPartitionsTimeoutMillis() {
        return this.nakadiConsumerProperties.getPartitionsTimeoutMillis();
    }

    public Long getEventsTimeoutMillis() {
        return this.nakadiConsumerProperties.getEventsTimeoutMillis();
    }

    public Long getEventsRetryAfterMillis() {
        return this.nakadiConsumerProperties.getEventsRetryAfterMillis();
    }

    public Long getEventsRetryRandomMillis() {
        return this.nakadiConsumerProperties.getEventsRetryRandomMillis();
    }

    public Integer getEventsStreamTimeoutSeconds() {
        return this.nakadiConsumerProperties.getEventsStreamTimeoutSeconds();
    }

    public Integer getEventsBatchTimeoutSeconds() {
        return this.nakadiConsumerProperties.getEventsBatchTimeoutSeconds();
    }

    public Integer getEventsStreamLimit() {
        return this.nakadiConsumerProperties.getEventsStreamLimit();
    }

    public Integer getEventsStreamKeepAliveLimit() {
        return this.nakadiConsumerProperties.getEventsStreamKeepAliveLimit();
    }

    public Integer getEventsBatchLimit() {
        return this.nakadiConsumerProperties.getEventsBatchLimit();
    }

    @Bean
    public EventReceiverRegistry eventReceiverRegistry(EventReceiverRegistryConfiguration eventReceiverConfig) {
        return new EventReceiverRegistry(eventReceiverConfig, this.objectMapper);
    }
}

