/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.boot;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import de.zalando.paradox.nakadi.consumer.boot.NakadiEventConsumer;
import de.zalando.paradox.nakadi.consumer.boot.NakadiEventConsumers;
import de.zalando.paradox.nakadi.consumer.boot.NakadiEventHandler;
import de.zalando.paradox.nakadi.consumer.boot.NakadiHandler;
import de.zalando.paradox.nakadi.consumer.boot.NakadiSettings;
import de.zalando.paradox.nakadi.consumer.boot.components.ConsumerEventConfig;
import de.zalando.paradox.nakadi.consumer.boot.components.ConsumerEventConfigList;
import de.zalando.paradox.nakadi.consumer.boot.components.ConsumerPartitionCoordinatorProvider;
import de.zalando.paradox.nakadi.consumer.boot.components.EventErrorHandlerList;
import de.zalando.paradox.nakadi.consumer.core.AuthorizationValueProvider;
import de.zalando.paradox.nakadi.consumer.core.EventHandler;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypeCursor;
import de.zalando.paradox.nakadi.consumer.core.partitioned.impl.SimplePartitionCoordinator;
import de.zalando.paradox.nakadi.consumer.partitioned.zk.ZKHolder;
import de.zalando.paradox.nakadi.consumer.partitioned.zk.ZKLeaderConsumerPartitionCoordinator;
import de.zalando.paradox.nakadi.consumer.partitioned.zk.ZKSimpleConsumerPartitionCoordinator;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.util.ReflectionUtils;
import org.zalando.stups.oauth2.spring.client.StupsTokensAccessTokenProvider;
import org.zalando.stups.tokens.AccessTokens;
import org.zalando.stups.tokens.config.AccessTokensBeanAutoConfiguration;

@Configuration
@AutoConfigureAfter(value={AccessTokensBeanAutoConfiguration.class})
public class NakadiConsumerConfiguration {
    private static final String DEFAULT_PROPERTIES_PREFIX = "paradox.nakadi.defaults";
    private static final Logger LOGGER = LoggerFactory.getLogger(NakadiConsumerConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private NakadiSettings nakadiConsumerProperties;

    @Bean
    public ConsumerEventConfigList consumerEventConfigList() {
        Map handlers = this.applicationContext.getBeansOfType(EventHandler.class);
        Function<Map.Entry, List> eventHandlerFunction = beanNameHandlerEntry -> {
            NakadiHandler nakadiHandler = null;
            Class<?> beanType = ((EventHandler)beanNameHandlerEntry.getValue()).getClass();
            String beanName = (String)beanNameHandlerEntry.getKey();
            Method method = ReflectionUtils.findMethod(beanType, (String)"onEvent", (Class[])new Class[]{EventTypeCursor.class, Object.class});
            if (null != method) {
                nakadiHandler = (NakadiHandler)AnnotationUtils.findAnnotation((Method)method, NakadiHandler.class);
            }
            if (null == nakadiHandler) {
                nakadiHandler = (NakadiHandler)AnnotationUtils.findAnnotation(beanType, NakadiHandler.class);
            }
            LinkedHashMultimap consumerToEvents = LinkedHashMultimap.create();
            if (null != nakadiHandler) {
                this.addEventToConsumer((SetMultimap<String, String>)consumerToEvents, nakadiHandler.eventName(), nakadiHandler.consumerName(), nakadiHandler.consumerNamePostfix());
            }
            if (NakadiEventHandler.class.isAssignableFrom(beanType)) {
                Object bean = this.applicationContext.getBean(beanName);
                Preconditions.checkState((boolean)(bean instanceof NakadiEventHandler), (Object)"bean must implement NakadiEventHandler");
                NakadiEventConsumers nakadiEventConsumers = ((NakadiEventHandler)bean).getNakadiEventConsumers();
                Preconditions.checkArgument((null != nakadiEventConsumers ? 1 : 0) != 0, (Object)"nakadiEventConsumers must not be null");
                Set<NakadiEventConsumer> beanEventConsumers = nakadiEventConsumers.getEventConsumers();
                if (null == beanEventConsumers || beanEventConsumers.isEmpty()) {
                    LOGGER.info("Empty Nakadi event consumers provided by [{} / {}]", (Object)beanName, beanType);
                } else {
                    beanEventConsumers.forEach(arg_0 -> this.lambda$null$8((SetMultimap)consumerToEvents, arg_0));
                }
            }
            return consumerToEvents.entries().stream().map(consumerEventEntry -> new ConsumerEventConfig((String)consumerEventEntry.getKey(), (String)consumerEventEntry.getValue(), (EventHandler)beanNameHandlerEntry.getValue())).collect(Collectors.toList());
        };
        List<ConsumerEventConfig> list = handlers.entrySet().stream().map(eventHandlerFunction).flatMap(Collection::stream).collect(Collectors.toList());
        return new ConsumerEventConfigList(list);
    }

    private void addEventToConsumer(SetMultimap<String, String> consumerToEvents, String eventName, String consumerName, boolean consumerNamePostfix) {
        String eventConsumerName;
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)eventName), (Object)"eventName must not be empty");
        if (consumerNamePostfix) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)consumerName), (Object)"consumerName for postfix 'true' attribute must not be empty");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.nakadiConsumerProperties.getDefaults().getDefaultConsumerName()), (Object)"defaultConsumerName for postfix 'true' attribute must not be empty");
            eventConsumerName = this.nakadiConsumerProperties.getDefaults().getDefaultConsumerName() + "-" + consumerName;
        } else {
            eventConsumerName = StringUtils.isNotEmpty((CharSequence)consumerName) ? consumerName : this.nakadiConsumerProperties.getDefaults().getDefaultConsumerName();
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)eventConsumerName), (Object)"consumerName must not be empty");
        consumerToEvents.put((Object)eventConsumerName, (Object)eventName);
    }

    @Bean
    @ConditionalOnProperty(value={"partitionCoordinatorProvider"}, prefix="paradox.nakadi.defaults", matchIfMissing=true, havingValue="simple")
    public ConsumerPartitionCoordinatorProvider simplePartitionCoordinatorProvider(EventErrorHandlerList eventErrorHandlerList) {
        return consumerName -> {
            SimplePartitionCoordinator coordinator = new SimplePartitionCoordinator(eventErrorHandlerList.getEventErrorHandlerList());
            coordinator.setStartNewestAvailableOffset(this.nakadiConsumerProperties.getDefaults().isStartNewestAvailableOffset());
            return coordinator;
        };
    }

    @Bean
    @ConditionalOnProperty(value={"partitionCoordinatorProvider"}, prefix="paradox.nakadi.defaults", havingValue="zk")
    public ConsumerPartitionCoordinatorProvider leaderConsumerPartitionCoordinator(ZKHolder zkHolder, EventErrorHandlerList eventErrorHandlerList) {
        return consumerName -> {
            ZKLeaderConsumerPartitionCoordinator coordinator = new ZKLeaderConsumerPartitionCoordinator(zkHolder, consumerName, eventErrorHandlerList.getEventErrorHandlerList());
            coordinator.setStartNewestAvailableOffset(this.nakadiConsumerProperties.getDefaults().isStartNewestAvailableOffset());
            coordinator.setDeleteUnavailableCursors(this.nakadiConsumerProperties.getDefaults().isDeleteUnavailableCursors());
            return coordinator;
        };
    }

    @Bean(initMethod="init")
    @ConditionalOnProperty(value={"partitionCoordinatorProvider"}, prefix="paradox.nakadi.defaults", havingValue="zk")
    public ZKHolder zkHolder() {
        return new ZKHolder(this.nakadiConsumerProperties.getDefaults().getZookeeperBrokers(), this.nakadiConsumerProperties.getDefaults().getExhibitorAddresses(), this.nakadiConsumerProperties.getDefaults().getExhibitorPort());
    }

    @Bean
    @ConditionalOnProperty(value={"partitionCoordinatorProvider"}, prefix="paradox.nakadi.defaults", havingValue="zk-simple")
    public ConsumerPartitionCoordinatorProvider simpleConsumerPartitionCoordinator(ZKHolder zkHolder, EventErrorHandlerList eventErrorHandlerList) {
        return consumerName -> {
            ZKSimpleConsumerPartitionCoordinator coordinator = new ZKSimpleConsumerPartitionCoordinator(zkHolder, consumerName, eventErrorHandlerList.getEventErrorHandlerList());
            coordinator.setStartNewestAvailableOffset(this.nakadiConsumerProperties.getDefaults().isStartNewestAvailableOffset());
            coordinator.setDeleteUnavailableCursors(this.nakadiConsumerProperties.getDefaults().isDeleteUnavailableCursors());
            return coordinator;
        };
    }

    @Bean(initMethod="init")
    @ConditionalOnProperty(value={"partitionCoordinatorProvider"}, prefix="paradox.nakadi.defaults", havingValue="zk-simple")
    public ZKHolder simpleZKHolder() {
        return new ZKHolder(this.nakadiConsumerProperties.getDefaults().getZookeeperBrokers(), this.nakadiConsumerProperties.getDefaults().getExhibitorAddresses(), this.nakadiConsumerProperties.getDefaults().getExhibitorPort());
    }

    @Bean
    @ConditionalOnProperty(value={"oauth2Enabled"}, prefix="paradox.nakadi.defaults", matchIfMissing=true, havingValue="true")
    public AuthorizationValueProvider oauth2AccessTokenProvider(AccessTokens accessTokens) {
        String tokenId = this.nakadiConsumerProperties.getDefaults().getNakadiTokenId();
        StupsTokensAccessTokenProvider accessTokenProvider = new StupsTokensAccessTokenProvider(tokenId, accessTokens);
        return () -> NakadiConsumerConfiguration.lambda$oauth2AccessTokenProvider$14((AccessTokenProvider)accessTokenProvider);
    }

    private static /* synthetic */ String lambda$oauth2AccessTokenProvider$14(AccessTokenProvider accessTokenProvider) {
        String accessToken = accessTokenProvider.obtainAccessToken(null, null).getValue();
        return String.format("Bearer %s", accessToken);
    }

    private /* synthetic */ void lambda$null$8(SetMultimap consumerToEvents, NakadiEventConsumer eventConsumer) {
        this.addEventToConsumer((SetMultimap<String, String>)consumerToEvents, eventConsumer.getEventName(), eventConsumer.getConsumerName(), false);
    }
}

