/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.boot;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.zalando.paradox.nakadi.consumer.boot.SQSConfiguration;
import de.zalando.paradox.nakadi.consumer.sqserrorhandler.SQSConfig;
import de.zalando.paradox.nakadi.consumer.sqserrorhandler.SQSErrorHandler;
import de.zalando.paradox.nakadi.consumer.sqserrorhandler.SQSFailedEventSource;
import de.zalando.paradox.nakadi.consumer.sqserrorhandler.SQSQueueHelper;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"enabled"}, prefix="paradox.nakadi.errorHandler.sqs", havingValue="true")
@Configuration
public class ErrorHandlerConfiguration {
    @Bean
    public AmazonSQS amazonSQS(SQSConfiguration sqsConfiguration) {
        AmazonSQSClientBuilder amazonSQSClientBuilder = AmazonSQSClientBuilder.standard();
        amazonSQSClientBuilder.setRegion(sqsConfiguration.getRegion());
        return (AmazonSQS)amazonSQSClientBuilder.build();
    }

    @Bean
    public SQSConfig sqsConfig(SQSConfiguration sqsConfiguration) {
        return new SQSConfig.Builder().createQueueIfNotExists(sqsConfiguration.isCreateQueueIfNotExists()).messageRetentionPeriod(sqsConfiguration.getMessageRetentionPeriod()).messageVisibilityTimeout(sqsConfiguration.getMessageVisibilityTimeout()).queueName(sqsConfiguration.getQueueName()).region(sqsConfiguration.getRegion()).build();
    }

    @Bean
    public ObjectMapper sqsErrorHandlerObjectMapper() {
        return new ObjectMapper();
    }

    @Bean
    public SQSErrorHandler sqsErrorHandler(SQSConfig sqsConfig, AmazonSQS amazonSQS, @Qualifier(value="sqsErrorHandlerObjectMapper") ObjectMapper objectMapper) {
        return new SQSErrorHandler(sqsConfig, amazonSQS, objectMapper);
    }

    @Bean
    public SQSQueueHelper sqsQueueHelper(SQSConfig sqsConfig, AmazonSQS amazonSQS) {
        return new SQSQueueHelper(sqsConfig, amazonSQS);
    }

    @Bean
    public SQSFailedEventSource sqsFailedEventSource(SQSQueueHelper sqsQueueHelper, SQSConfig sqsConfig, AmazonSQS amazonSQS, @Qualifier(value="sqsErrorHandlerObjectMapper") ObjectMapper objectMapper) {
        return new SQSFailedEventSource(sqsConfig, amazonSQS, objectMapper);
    }
}

