/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.zalando.paradox.nakadi.consumer.boot.EventReceiverRegistryConfiguration;
import de.zalando.paradox.nakadi.consumer.boot.NakadiSettings;
import de.zalando.paradox.nakadi.consumer.core.AuthorizationValueProvider;
import de.zalando.paradox.nakadi.consumer.core.client.Client;
import de.zalando.paradox.nakadi.consumer.core.client.impl.ClientImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ClientConfiguration {
    @Autowired
    private NakadiSettings nakadiSettings;
    @Autowired(required=false)
    private AuthorizationValueProvider authorizationValueProvider;
    @Autowired(required=false)
    @Qualifier(value="nakadiObjectMapper")
    private ObjectMapper objectMapper;

    @Bean
    public Client nakadiClient(EventReceiverRegistryConfiguration eventReceiverConfig) {
        ClientImpl.Builder builder = new ClientImpl.Builder(this.nakadiSettings.getDefaults().getNakadiUrl());
        if (null != this.authorizationValueProvider) {
            builder.withAuthorization(this.authorizationValueProvider);
        }
        if (null != this.objectMapper) {
            builder.withObjectMapper(this.objectMapper);
        }
        return builder.build();
    }
}

