/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.boot;

import de.zalando.paradox.nakadi.consumer.boot.FailedEventReplayer;
import de.zalando.paradox.nakadi.consumer.boot.ReplayHandler;
import de.zalando.paradox.nakadi.consumer.boot.components.EventReceiverRegistry;
import de.zalando.paradox.nakadi.consumer.boot.components.EventTypeConsumer;
import de.zalando.paradox.nakadi.consumer.boot.components.FailedEventSourceNameResponse;
import de.zalando.paradox.nakadi.consumer.boot.components.NumberOfFailedEventsResponse;
import de.zalando.paradox.nakadi.consumer.core.EventHandler;
import de.zalando.paradox.nakadi.consumer.core.client.Client;
import de.zalando.paradox.nakadi.consumer.core.domain.EventType;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypeCursor;
import de.zalando.paradox.nakadi.consumer.core.domain.EventTypePartition;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import rx.Single;

@Configuration
public class ControllerConfiguration {

    @RestController
    @RequestMapping(value={"/nakadi/event-handlers"})
    public static class EventHandlerController {
        private static final long DEFERRED_TIMEOUT = 20000L;
        private final ReplayHandler replayHandler = new ReplayHandler();
        private EventReceiverRegistry registry;
        private Client client;

        @Autowired
        public EventHandlerController(EventReceiverRegistry registry, Client client) {
            this.registry = registry;
            this.client = client;
        }

        @RequestMapping(produces={"application/json"})
        public Set<EventTypeConsumer> getAllEventTypeConsumers() throws Exception {
            return this.registry.getEventTypeConsumers();
        }

        @RequestMapping(value={"/event_types/{event_type:.+}/partitions/{partition}/offsets/{offset}/replays"}, produces={"text/plain"}, method={RequestMethod.POST})
        public DeferredResult<ResponseEntity<?>> replay(@PathVariable(value="event_type") String eventName, @PathVariable(value="partition") String partition, @PathVariable(value="offset") String offset, @RequestParam(value="consumer_name", required=false) String consumerName, @RequestParam(value="verbose", required=false, defaultValue="false") boolean verbose) {
            if (this.validateConsumerNameAndEventType(consumerName, eventName)) {
                return this.getBadDeferredResult();
            }
            EventTypePartition eventTypePartition = EventTypePartition.of((EventType)EventType.of((String)eventName), (String)partition);
            EventTypeCursor queryCursor = this.replayHandler.getQueryCursor(EventTypeCursor.of((EventTypePartition)eventTypePartition, (String)offset));
            Single singleContent = this.client.getContent(queryCursor);
            return this.deferredReplayResult(eventTypePartition, consumerName, verbose, (Single<String>)singleContent);
        }

        @RequestMapping(value={"/event_types/{event_type:.+}/partitions/{partition}/restores"}, produces={"text/plain"}, method={RequestMethod.POST})
        public DeferredResult<ResponseEntity<?>> restore(@PathVariable(value="event_type") String eventName, @PathVariable(value="partition") String partition, @RequestParam(value="consumer_name", required=false) String consumerName, @RequestParam(value="verbose", required=false, defaultValue="false") boolean verbose, @RequestBody String content) {
            if (this.validateConsumerNameAndEventType(consumerName, eventName)) {
                return this.getBadDeferredResult();
            }
            EventTypePartition eventTypePartition = EventTypePartition.of((EventType)EventType.of((String)eventName), (String)partition);
            Single singleContent = Single.just((Object)content);
            return this.deferredReplayResult(eventTypePartition, consumerName, verbose, (Single<String>)singleContent);
        }

        private DeferredResult<ResponseEntity<?>> deferredReplayResult(EventTypePartition eventTypePartition, String consumerName, boolean verbose, Single<String> singleContent) {
            DeferredResult deferredResult = new DeferredResult(Long.valueOf(20000L));
            Set consumers = this.registry.getEventTypeConsumers().stream().filter(this.filterConsumer(eventTypePartition.getName(), consumerName)).collect(Collectors.toSet());
            if (consumers.isEmpty()) {
                deferredResult.setErrorResult((Object)ResponseEntity.notFound().build());
            } else {
                singleContent.subscribe(content -> {
                    consumers.forEach(eventTypeConsumer -> {
                        EventHandler<?> handler = Objects.requireNonNull(this.registry.getEventTypeConsumerHandler((EventTypeConsumer)eventTypeConsumer), "handler not found");
                        this.replayHandler.handle(consumerName, handler, eventTypePartition, (String)content);
                    });
                    deferredResult.setResult((Object)ResponseEntity.ok((Object)(verbose ? content : "")));
                }, throwable -> deferredResult.setErrorResult((Object)ResponseEntity.badRequest().body((Object)throwable.toString())));
            }
            return deferredResult;
        }

        private Predicate<EventTypeConsumer> filterConsumer(@Nonnull String eventName, @Nullable String consumerName) {
            return elem -> elem.getEventName().equals(eventName) && (null == consumerName || elem.getConsumerName().equals(consumerName));
        }

        private DeferredResult<ResponseEntity<?>> getBadDeferredResult() {
            DeferredResult deferredResult = new DeferredResult();
            deferredResult.setErrorResult((Object)ResponseEntity.badRequest().body((Object)"Consumer not found."));
            return deferredResult;
        }

        private boolean validateConsumerNameAndEventType(String consumerName, String eventType) {
            return this.registry.getEventTypeConsumers().stream().noneMatch(this.filterConsumer(eventType, consumerName));
        }
    }

    @RestController
    @RequestMapping(value={"/nakadi/event-receivers"})
    public static class EventReceiverController {
        private EventReceiverRegistry registry;

        @Autowired
        public EventReceiverController(EventReceiverRegistry registry) {
            this.registry = registry;
        }

        @RequestMapping(value={"/stop"}, method={RequestMethod.POST})
        public void stop() throws Exception {
            this.registry.stop();
        }

        @RequestMapping(value={"/restart"}, method={RequestMethod.POST})
        public void restart() {
            this.registry.restart();
        }
    }

    @RestController
    @RequestMapping(value={"/nakadi/failed-event-sources"})
    public static class FailedEventReplayController {
        private final FailedEventReplayer failedEventReplayer;

        @Autowired
        public FailedEventReplayController(FailedEventReplayer failedEventReplayer) {
            this.failedEventReplayer = failedEventReplayer;
        }

        @RequestMapping(produces={"application/json"})
        public FailedEventSourceNameResponse getFailedEventSources() {
            return new FailedEventSourceNameResponse(this.failedEventReplayer.getFailedEventSources());
        }

        @RequestMapping(value={"/{event_source_name:.+}"}, produces={"application/json"})
        public NumberOfFailedEventsResponse getTotalNumberOfFailedEvents(@PathVariable(value="event_source_name") String eventSourceName) {
            return new NumberOfFailedEventsResponse(this.failedEventReplayer.getTotalNumberOfFailedEvents(eventSourceName));
        }

        @RequestMapping(value={"/{event_source_name:.+}"}, method={RequestMethod.POST}, produces={"application/json"})
        public ResponseEntity<?> replay(@PathVariable(value="event_source_name") String eventSourceName, @RequestParam(value="number_of_failed_events") long numberOfFailedEvents, @RequestParam(value="break_processing_on_exception", defaultValue="false") boolean breakProcessingOnException) {
            try {
                this.failedEventReplayer.replay(eventSourceName, numberOfFailedEvents, breakProcessingOnException);
                return ResponseEntity.ok().build();
            }
            catch (Exception ex) {
                return ResponseEntity.badRequest().body((Object)ex);
            }
        }
    }
}

