/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.boot;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.zalando.paradox.nakadi.consumer.boot.SQSConfiguration;
import de.zalando.paradox.nakadi.consumer.sqserrorhandler.SQSConfig;
import de.zalando.paradox.nakadi.consumer.sqserrorhandler.SQSErrorHandler;
import de.zalando.paradox.nakadi.consumer.sqserrorhandler.SQSFailedEventSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"enabled"}, prefix="paradox.nakadi.errorHandler.sqs", havingValue="true")
@Configuration
public class ErrorHandlerConfiguration {
    @Bean
    public AmazonSQS amazonSQS(SQSConfiguration sqsConfiguration) {
        return (AmazonSQS)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withRegion(sqsConfiguration.getRegion())).build();
    }

    @Bean
    public SQSConfig sqsConfig(SQSConfiguration sqsConfiguration) {
        return new SQSConfig.Builder().queueUrl(sqsConfiguration.getQueueUrl()).build();
    }

    @Bean
    public ObjectMapper sqsErrorHandlerObjectMapper() {
        return new ObjectMapper();
    }

    @Bean
    public SQSErrorHandler sqsErrorHandler(SQSConfig sqsConfig, AmazonSQS amazonSQS, @Qualifier(value="sqsErrorHandlerObjectMapper") ObjectMapper objectMapper) {
        return new SQSErrorHandler(sqsConfig, amazonSQS, objectMapper);
    }

    @Bean
    public SQSFailedEventSource sqsFailedEventSource(SQSConfig sqsConfig, AmazonSQS amazonSQS, @Qualifier(value="sqsErrorHandlerObjectMapper") ObjectMapper objectMapper) {
        return new SQSFailedEventSource(sqsConfig, amazonSQS, objectMapper);
    }
}

