/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.zalando.paradox.nakadi.consumer.boot.NakadiConsumerSettings;
import de.zalando.paradox.nakadi.consumer.boot.NakadiSettings;
import de.zalando.paradox.nakadi.consumer.boot.components.ConsumerEventConfigList;
import de.zalando.paradox.nakadi.consumer.boot.components.ConsumerPartitionCoordinatorProvider;
import de.zalando.paradox.nakadi.consumer.boot.components.EventReceiverRegistry;
import de.zalando.paradox.nakadi.consumer.core.AuthorizationValueProvider;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EventReceiverRegistryConfiguration {
    private static final NakadiConsumerSettings EMPTY_CONSUMER_SETTINGS = new NakadiConsumerSettings();
    @Autowired
    private NakadiSettings nakadiSettings;
    @Autowired
    private ConsumerPartitionCoordinatorProvider coordinatorProvider;
    @Autowired
    private ConsumerEventConfigList consumerEventConfigList;
    @Autowired(required=false)
    private AuthorizationValueProvider authorizationValueProvider;
    @Autowired(required=false)
    @Qualifier(value="nakadiObjectMapper")
    private ObjectMapper objectMapper;

    @Bean
    public EventReceiverRegistry eventReceiverRegistry(EventReceiverRegistryConfiguration eventReceiverConfig) {
        return new EventReceiverRegistry(eventReceiverConfig, this.objectMapper);
    }

    public ConsumerPartitionCoordinatorProvider getCoordinatorProvider() {
        return this.coordinatorProvider;
    }

    public ConsumerEventConfigList getConsumerEventConfigList() {
        return this.consumerEventConfigList;
    }

    public AuthorizationValueProvider getAuthorizationValueProvider() {
        return this.authorizationValueProvider;
    }

    public String getNakadiUrl() {
        return this.nakadiSettings.getDefaults().getNakadiUrl();
    }

    public boolean isEventTypePartitionCoordinator() {
        return this.nakadiSettings.getDefaults().isEventTypePartitionCoordinator();
    }

    public Long getPartitionsRetryAfterMillis() {
        return this.nakadiSettings.getDefaults().getPartitionsRetryAfterMillis();
    }

    public Long getPartitionsRetryRandomMillis() {
        return this.nakadiSettings.getDefaults().getPartitionsRetryRandomMillis();
    }

    public Long getPartitionsTimeoutMillis() {
        return this.nakadiSettings.getDefaults().getPartitionsTimeoutMillis();
    }

    public Long getEventsTimeoutMillis() {
        return this.nakadiSettings.getDefaults().getEventsTimeoutMillis();
    }

    public Long getEventsRetryAfterMillis() {
        return this.nakadiSettings.getDefaults().getEventsRetryAfterMillis();
    }

    public Long getEventsRetryRandomMillis() {
        return this.nakadiSettings.getDefaults().getEventsRetryRandomMillis();
    }

    public Integer getEventsStreamTimeoutSeconds() {
        return this.nakadiSettings.getDefaults().getEventsStreamTimeoutSeconds();
    }

    public Integer getEventsBatchTimeoutSeconds() {
        return this.nakadiSettings.getDefaults().getEventsBatchTimeoutSeconds();
    }

    public Integer getEventsBatchTimeoutSeconds(String consumer) {
        return Stream.of(this.getConsumerSetting(consumer).getEventsBatchTimeoutSeconds(), this.nakadiSettings.getDefaults().getEventsBatchTimeoutSeconds()).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Integer getEventsStreamLimit() {
        return this.nakadiSettings.getDefaults().getEventsStreamLimit();
    }

    public Integer getEventsStreamKeepAliveLimit() {
        return this.nakadiSettings.getDefaults().getEventsStreamKeepAliveLimit();
    }

    public Integer getEventsBatchLimit() {
        return this.nakadiSettings.getDefaults().getEventsBatchLimit();
    }

    public Integer getEventsBatchLimit(String consumer) {
        return Stream.of(this.getConsumerSetting(consumer).getEventsBatchLimit(), this.nakadiSettings.getDefaults().getEventsBatchLimit()).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private NakadiConsumerSettings getConsumerSetting(String consumer) {
        return this.nakadiSettings.getConsumers().getOrDefault(consumer, EMPTY_CONSUMER_SETTINGS);
    }
}

