/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.boot;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class NakadiEventConsumer {
    public final String eventName;
    public final String consumerName;

    public NakadiEventConsumer(String eventName, @Nullable String consumerName) {
        Preconditions.checkArgument((null != eventName && !eventName.isEmpty() ? 1 : 0) != 0, (Object)"eventName must not be empty");
        this.eventName = eventName;
        this.consumerName = consumerName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public static NakadiEventConsumer of(String eventName, @Nullable String consumerName) {
        return new NakadiEventConsumer(eventName, consumerName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NakadiEventConsumer that = (NakadiEventConsumer)o;
        return Objects.equal((Object)this.eventName, (Object)that.eventName) && Objects.equal((Object)this.consumerName, (Object)that.consumerName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.eventName, this.consumerName});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("eventName", (Object)this.eventName).add("consumerName", (Object)this.consumerName).toString();
    }
}

