/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.paradox.nakadi.consumer.boot;

import com.google.common.collect.ImmutableSet;
import de.zalando.paradox.nakadi.consumer.boot.NakadiEventConsumer;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;

public class NakadiEventConsumers {
    private static final NakadiEventConsumers EMPTY = new NakadiEventConsumers(Collections.emptySet());
    private final Set<NakadiEventConsumer> eventConsumers;

    public NakadiEventConsumers(Set<NakadiEventConsumer> eventConsumers) {
        this.eventConsumers = eventConsumers;
    }

    public static NakadiEventConsumers single(String eventName, @Nullable String consumerName) {
        return new NakadiEventConsumers(Collections.singleton(NakadiEventConsumer.of(eventName, consumerName)));
    }

    public static NakadiEventConsumers of(NakadiEventConsumer ... eventConsumers) {
        return new NakadiEventConsumers((Set<NakadiEventConsumer>)ImmutableSet.copyOf((Object[])eventConsumers));
    }

    public static NakadiEventConsumers empty() {
        return EMPTY;
    }

    public Set<NakadiEventConsumer> getEventConsumers() {
        return this.eventConsumers;
    }
}

